<?php

use App\Http\Controllers\EarlyAccessController;
use App\Http\Controllers\LemonSqueezyWebhookController;
use App\Http\Controllers\PlanController;
use Illuminate\Support\Facades\Route;
use Inertia\Inertia;

Route::get('/', function () {
    $faqs = \App\Models\Faq::active()->ordered()->get();
    $testimonials = \App\Models\Testimonial::active()->ordered()->get();
    $features = \App\Models\Feature::active()->ordered()->get();
    $whatToExpect = \App\Models\WhatToExpect::active()->orderBy('order')->get();
    return Inertia::render('welcome', [
        'faqs' => $faqs,
        'testimonials' => $testimonials,
        'features' => $features,
        'whatToExpect' => $whatToExpect,
    ]);
})->name('home');

Route::post('/early-access', [EarlyAccessController::class, 'store'])->name('early-access.store');
Route::get('/verify-early-access/{token}', [EarlyAccessController::class, 'verify'])->name('early-access.verify');

// Pages
Route::get('/pages/{page:slug}', [App\Http\Controllers\PageController::class, 'show'])->name('pages.show');

// Lemon Squeezy Webhook
Route::post('/lemon-squeezy/webhook', LemonSqueezyWebhookController::class)
//    ->middleware('lemon-squeezy.verify-signature')
    ->name('lemon-squeezy.webhook');

// Plans API
Route::get('/api/plans', [PlanController::class, 'index'])->name('api.plans.index');

// Subscription routes
Route::middleware(['auth'])->prefix('subscription')->name('subscription.')->group(function () {
    Route::get('/', [App\Http\Controllers\SubscriptionController::class, 'index'])->name('index');
    Route::get('/checkout/{planId}', [App\Http\Controllers\SubscriptionController::class, 'checkout'])->name('checkout');
    Route::get('/success', [App\Http\Controllers\SubscriptionController::class, 'success'])->name('success');
    Route::post('/cancel', [App\Http\Controllers\SubscriptionController::class, 'cancel'])->name('cancel');
    Route::post('/resume', [App\Http\Controllers\SubscriptionController::class, 'resume'])->name('resume');
    Route::post('/change-plan', [App\Http\Controllers\SubscriptionController::class, 'changePlan'])->name('change-plan');
});

Route::middleware(['auth', 'verified'])->group(function () {
    Route::get('dashboard', function () {
        return Inertia::render('dashboard');
    })->name('dashboard');

    // Feature 1 - Available to users with Starter plan or higher
    Route::get('/features/feature1', [App\Http\Controllers\Feature1Controller::class, 'index'])
        ->middleware('feature:feature1,starter')
        ->name('features.feature1');

    // Feature 5 - Available only to Pro plan users
    Route::get('/features/feature5', [App\Http\Controllers\Feature5Controller::class, 'index'])
        ->middleware('feature:feature5,pro')
        ->name('features.feature5');
});

require __DIR__.'/settings.php';
require __DIR__.'/auth.php';
