import { useState, useEffect } from 'react';
import axios from 'axios';

export interface Plan {
  id: number;
  name: string;
  slug: string;
  billing_interval: string;
  price_cents: number;
  lemonsqueezy_product_id: string;
  lemonsqueezy_price_id: string;
  description: string | null;
  features: {
    feature: string;
    enabled: boolean;
  }[];
  is_active: boolean;
  created_at: string;
  updated_at: string;
}

export function usePlans() {
  const [plans, setPlans] = useState<Plan[]>([]);
  const [loading, setLoading] = useState(true);
  const [error, setError] = useState<string | null>(null);

  useEffect(() => {
    const fetchPlans = async () => {
      try {
        setLoading(true);
        const response = await axios.get('/api/plans');
        setPlans(response.data.plans);
        setError(null);
      } catch (err) {
        console.error('Error fetching plans:', err);
        setError('Failed to load subscription plans');
      } finally {
        setLoading(false);
      }
    };

    fetchPlans();
  }, []);

  return { plans, loading, error };
}
