<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class EarlyAccessSignup extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = ['email', 'token', 'is_verified', 'verified_at', 'signed_up_at'];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'signed_up_at' => 'datetime',
        'verified_at' => 'datetime',
        'is_verified' => 'boolean',
    ];
    
    /**
     * Scope a query to find a signup by its token.
     *
     * @param  \Illuminate\Database\Eloquent\Builder  $query
     * @param  string  $token
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function scopeByToken($query, $token)
    {
        return $query->where('token', $token);
    }
}
