<?php

namespace App\Http\Controllers;

use App\Models\Plan;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class PlanController extends Controller
{
    /**
     * Get all active pricing plans
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function index(): JsonResponse
    {
        $plans = Plan::where('is_active', true)->orderBy('price_cents')->get();

        return response()->json([
            'plans' => $plans
        ]);
    }
}
