<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\App;
use Symfony\Component\HttpFoundation\Response;

class LemonSqueezyWebhookController extends Controller
{
    /**
     * Handle the incoming webhook request.
     *
     * @param Request $request
     * @return Response
     */
    public function __invoke(Request $request)
    {
        // Log the webhook for debugging
        Log::info('Lemon Squeezy Webhook received', [
            'event' => $request->input('meta.event_name'),
            'type' => $request->input('data.type'),
            'payload' => $request->all()
        ]);

        // Use the WebhookController from the package
        // The middleware will have already verified the signature
        $controller = App::make('LemonSqueezy\\Laravel\\Http\\Controllers\\WebhookController');
        return $controller($request);
    }
}
