<?php

namespace App\Filament\Resources;

use App\Filament\Exports\EarlyAccessSignupExporter;
use App\Filament\Resources\EarlyAccessSignupResource\Pages;
use App\Filament\Resources\EarlyAccessSignupResource\RelationManagers;
use App\Models\EarlyAccessSignup;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class EarlyAccessSignupResource extends Resource
{
    protected static ?string $model = EarlyAccessSignup::class;

    protected static ?string $navigationIcon = 'heroicon-o-envelope';
    
    protected static ?string $navigationGroup = 'Marketing';
    
    protected static ?string $navigationLabel = 'Email Leads';
    
    protected static ?int $navigationSort = 1;

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\Section::make('Lead Information')
                    ->schema([
                        Forms\Components\TextInput::make('email')
                            ->email()
                            ->required()
                            ->unique(ignoreRecord: true)
                            ->columnSpan(2),
                            
                        Forms\Components\Toggle::make('is_verified')
                            ->required()
                            ->label('Verified'),
                            
                        Forms\Components\DateTimePicker::make('signed_up_at')
                            ->label('Signed Up At')
                            ->required(),
                            
                        Forms\Components\DateTimePicker::make('verified_at')
                            ->label('Verified At'),
                    ])
                    ->columns(2),
                    
                Forms\Components\Section::make('System Information')
                    ->schema([
                        Forms\Components\TextInput::make('token')
                            ->helperText('Verification token used in email verification links')
                            ->columnSpan(2),
                    ])
                    ->collapsed(),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('email')
                    ->searchable()
                    ->sortable()
                    ->copyable(),
                Tables\Columns\IconColumn::make('is_verified')
                    ->boolean()
                    ->label('Verified')
                    ->sortable(),
                Tables\Columns\TextColumn::make('signed_up_at')
                    ->dateTime()
                    ->sortable()
                    ->label('Signed Up'),
                Tables\Columns\TextColumn::make('verified_at')
                    ->dateTime()
                    ->sortable()
                    ->label('Verified At'),
                Tables\Columns\TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('token')
                    ->searchable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                Tables\Filters\SelectFilter::make('is_verified')
                    ->label('Verification Status')
                    ->options([
                        '1' => 'Verified',
                        '0' => 'Not Verified',
                    ]),
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                    Tables\Actions\ExportBulkAction::make()
                        ->label('Export Selected')
                        ->exporter(EarlyAccessSignupExporter::class)
                ]),
            ])
            ->headerActions([
                Tables\Actions\ExportAction::make()
                    ->label('Export All')
                    ->color('success')
                    ->exporter(EarlyAccessSignupExporter::class)
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListEarlyAccessSignups::route('/'),
            'create' => Pages\CreateEarlyAccessSignup::route('/create'),
            'edit' => Pages\EditEarlyAccessSignup::route('/{record}/edit'),
        ];
    }
}
