<div>
    @if (session()->has('success'))
        <div class="mb-4 bg-green-50 dark:bg-green-900 border-l-4 border-green-400 p-4">
            <div class="flex">
                <div class="flex-shrink-0">
                    <svg class="h-5 w-5 text-green-400" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                    </svg>
                </div>
                <div class="ml-3">
                    <div class="text-sm text-green-700 dark:text-green-200">
                        {{ session('success') }}
                    </div>
                </div>
            </div>
        </div>
    @endif

    @if (session()->has('error'))
        <div class="mb-4 bg-red-50 dark:bg-red-900 border-l-4 border-red-400 p-4">
            <div class="flex">
                <div class="flex-shrink-0">
                    <svg class="h-5 w-5 text-red-400" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd"/>
                    </svg>
                </div>
                <div class="ml-3">
                    <div class="text-sm text-red-700 dark:text-red-200">
                        {{ session('error') }}
                    </div>
                </div>
            </div>
        </div>
    @endif

    <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center gap-4 mb-6">
        <div class="flex-1 flex flex-col sm:flex-row gap-4 w-full sm:w-auto">
            <div class="flex-1 max-w-md">
                <flux:input wire:model.live="search" placeholder="🔍 Search categories..." />
            </div>

            <div class="w-full sm:w-48">
                <flux:select wire:model.live="typeFilter">
                    <option value="">All Types</option>
                    @foreach($availableTypes as $typeOption)
                        <option value="{{ $typeOption['value'] }}">{{ $typeOption['label'] }}</option>
                    @endforeach
                </flux:select>
            </div>
        </div>

        <x-ticaga-button href="{{ route('settings.categories.create', ['type' => $typeFilter ?: ($availableTypes[0]['value'] ?? 'announcements')]) }}" icon="plus" class="!bg-indigo-700 hover:!bg-indigo-500 !text-white">
            Create Category
        </x-ticaga-button>
    </div>

    @if((!$search && $categories->isEmpty()) || ($search && $categories->isEmpty()))
        <div class="text-center py-12 bg-gray-50 dark:bg-gray-800 rounded-lg">
            <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z" />
            </svg>
            <h3 class="mt-2 text-sm font-medium text-gray-900 dark:text-gray-100">No categories found</h3>
            <p class="mt-1 text-sm text-gray-500 dark:text-gray-400">
                @if($search)
                    No categories match your search criteria.
                @else
                    Get started by creating a new category.
                @endif
            </p>
        </div>
    @else
        <div class="overflow-x-auto bg-white dark:bg-gray-800 rounded-lg shadow">
            <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                <thead class="bg-gray-50 dark:bg-gray-900">
                    <tr>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wider">
                            Category Name
                        </th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wider">
                            Type
                        </th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wider">
                            URL Slug
                        </th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wider">
                            Status
                        </th>
                        <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wider">
                            Actions
                        </th>
                    </tr>
                </thead>
                <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                    @if($search)
                        {{-- Flat list when searching --}}
                        @foreach($categories as $category)
                            <tr class="hover:bg-gray-50 dark:hover:bg-gray-700">
                                <td class="px-6 py-4">
                                    <div class="text-sm font-medium text-gray-900 dark:text-gray-100">
                                        {{ $category->category_name }}
                                    </div>
                                    @if($category->parent)
                                        <div class="text-xs text-gray-500 dark:text-gray-400 mt-1">
                                            {{ $category->getBreadcrumbPath() }}
                                        </div>
                                    @endif
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <flux:badge color="zinc" size="sm">{{ $category->type instanceof \BackedEnum ? ucfirst($category->type->value) : ucfirst($category->type) }}</flux:badge>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm text-gray-500 dark:text-gray-400">
                                        {{ $category->uri }}
                                    </div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    @if($category->display)
                                        <flux:badge color="green" size="sm">Visible</flux:badge>
                                    @else
                                        <flux:badge color="gray" size="sm">Hidden</flux:badge>
                                    @endif
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium space-x-2">
                                    <a href="{{ route('settings.categories.edit', $category->id) }}"
                                       class="text-indigo-600 hover:text-indigo-900 dark:text-indigo-400 dark:hover:text-indigo-300">
                                        Edit
                                    </a>
                                    <button wire:click="confirmDelete({{ $category->id }})"
                                            class="text-red-600 hover:text-red-900 dark:text-red-400 dark:hover:text-red-300">
                                        Delete
                                    </button>
                                </td>
                            </tr>
                        @endforeach
                    @else
                        {{-- Hierarchical tree view when not searching --}}
                        @foreach($categories as $category)
                            @include('livewire.settings.categories.partials.category-row', ['category' => $category, 'depth' => 0])
                        @endforeach
                    @endif
                </tbody>
            </table>
        </div>

        @if($search)
            <div class="mt-4">
                {{ $categories->links() }}
            </div>
        @endif
    @endif

    <!-- Delete Confirmation Modal -->
    <flux:modal wire:model="showDeleteModal" variant="flyout">
        <div>
            <flux:heading size="lg">Confirm Deletion</flux:heading>
            <flux:subheading class="mt-2">
                Are you sure you want to delete this category? This action cannot be undone.
            </flux:subheading>

            <div class="mt-6 flex justify-end space-x-3">
                <flux:button wire:click="cancelDelete" variant="ghost">
                    Cancel
                </flux:button>
                <flux:button wire:click="deleteCategory" variant="danger">
                    Delete Category
                </flux:button>
            </div>
        </div>
    </flux:modal>
</div>
