<div>
    <form wire:submit.prevent="save">
        <div class="bg-white dark:bg-gray-800">
            <div class="space-y-6">
                <!-- Category Type -->
                <div>
                    <flux:label for="type" required>Category Type</flux:label>
                    <flux:select wire:model.live="type" id="type" :disabled="$parent_id">
                        @foreach($availableTypes as $value => $label)
                            <option value="{{ $value }}">{{ $label }}</option>
                        @endforeach
                    </flux:select>
                    @error('type')
                        <flux:error>{{ $message }}</flux:error>
                    @enderror
                    <flux:description>
                        The type of content this category will organize.
                        @if($parent_id)
                            <br><span class="text-amber-600 dark:text-amber-400">Type is inherited from parent category.</span>
                        @endif
                    </flux:description>
                </div>

                <!-- Category Name -->
                <div>
                    <flux:label for="category_name" required>Category Name</flux:label>
                    <flux:input
                        wire:model.live="category_name"
                        id="category_name"
                        type="text"
                        placeholder="e.g., Getting Started, Troubleshooting, FAQs"
                        required
                    />
                    @error('category_name')
                        <flux:error>{{ $message }}</flux:error>
                    @enderror
                </div>

                <!-- Parent Category -->
                <div>
                    <flux:label for="parent_id">Parent Category (Optional)</flux:label>
                    <flux:select wire:model="parent_id" id="parent_id">
                        <option value="">None - Top-level category</option>
                        @foreach($availableParents as $parent)
                            <option value="{{ $parent->id }}">
                                @if($parent->parent)
                                    {{ $parent->getBreadcrumbPath(' > ') }}
                                @else
                                    {{ $parent->category_name }}
                                @endif
                            </option>
                        @endforeach
                    </flux:select>
                    @error('parent_id')
                        <flux:error>{{ $message }}</flux:error>
                    @enderror
                </div>

                <!-- Sort Order -->
                <div>
                    <flux:label for="sort_order">Sort Order</flux:label>
                    <flux:input wire:model="sort_order" id="sort_order" type="number" min="0" placeholder="0" />
                </div>

                <!-- URL Slug -->
                <div>
                    <div class="flex items-center justify-between">
                        <flux:label for="uri" required>URL Slug</flux:label>
                        <div class="flex items-center space-x-2">
                            <x-ticaga-checkbox wire:model.live="auto_generate_uri" wire:click="toggleAutoGenerateUri" id="auto_generate_uri" />
                            <label for="auto_generate_uri" class="text-sm text-gray-700 dark:text-gray-300 cursor-pointer">Auto-generate</label>
                        </div>
                    </div>
                    <flux:input wire:model.blur="uri" id="uri" type="text" placeholder="e.g., getting-started" :disabled="$auto_generate_uri" required />
                    @error('uri')
                        <flux:error>{{ $message }}</flux:error>
                    @enderror
                </div>

                <!-- Visibility -->
                <div>
                    <flux:label for="display">Visibility</flux:label>
                    <flux:select wire:model="display" id="display">
                        <option value="1">Visible - Show to users</option>
                        <option value="0">Hidden - Admin only</option>
                    </flux:select>
                </div>
            </div>

            <!-- Action Buttons -->
            <div class="mt-8 flex items-center justify-between border-t border-gray-200 dark:border-gray-700 pt-6">
                <flux:button href="{{ route('settings.categories') }}" variant="ghost">Cancel</flux:button>
                <flux:button type="submit" class="!bg-indigo-700 hover:!bg-indigo-500 !text-white">Create Category</flux:button>
            </div>
        </div>
    </form>
</div>
