<div class="bg-white border border-neutral-200 rounded-lg shadow-sm p-8 dark:bg-gray-900 dark:border-neutral-700 mt-4">
    <form wire:submit="search">
        <div class="col-span-full">
            <label for="email" class="block text-sm/6 font-medium text-gray-900 dark:text-white">{{ __('Email Address') }}</label>
            <div class="mt-2">
                <input type="text" name="email" id="email" class="block w-full rounded-md px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 dark:text-white dark:bg-gray-900 dark:outline-gray-600 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6" wire:model.live="email" require>
                @error('email') <em class="dark:text-white">{{ $message }}</em>@enderror
            </div>
        </div>
        <div class="col-span-full mt-4">
            <label for="public_hash" class="block text-sm/6 font-medium text-gray-900 dark:text-white">{{ __('Public Hash') }}</label>
            <div class="mt-2">
                <input type="text" name="public_hash" id="public_hash" class="block w-full rounded-md px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 dark:text-white dark:bg-gray-900 dark:outline-gray-600 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6" wire:model.live="public_hash" require>
                @error('public_hash') <em class="dark:text-white">{{ $message }}</em>@enderror
            </div>
        </div>
        <flux:button class="!bg-indigo-700 hover:!bg-indigo-500 !text-white mt-4" type="submit">{{ __('Search') }}</flux:button>
    </form>
</div>
