<div wire:poll.visible>
    @hasanyrole('employee|admin|superadmin')
        <div class="grid auto-rows-min gap-4 md:grid-cols-2">
            <!-- This shows the something. -->
            <div class="bg-white border border-neutral-200 rounded-lg shadow-sm p-8 dark:bg-gray-900 dark:border-neutral-700">
                <div class="flex items-center justify-between mb-4">
                    <h5 class="text-xl font-bold leading-none text-gray-900 dark:text-white">
                        {{ __('Latest Tickets') }}
                    </h5>
                    <a href="{{ route('view_tickets') }}" class="text-sm font-medium text-blue-600 hover:underline dark:text-white dark:underline dark:underline-offset-8 dark:hover:underline-offset-8">
                        {{ __('View all') }}
                    </a>
                </div>
                <div class="flow-root">
                        <ul role="list" class="divide-y divide-gray-200 dark:divide-gray-700">
                            @if($tickets_count  != '0')
                                @foreach( $tickets as $ticket)
                                    <li class="py-3">
                                        <div class="flex items-center">
                                            <div class="flex-1 min-w-0">
                                                <a href="./tickets/show/{{ $ticket->ticket_id }}">
                                                    <p class="text-sm font-medium text-gray-900 truncate dark:text-white">
                                                        {{ Str::limit($ticket->subject,28, preserveWords: true) }}
                                                    </p>
                                                </a>
                                                <p class="text-sm text-gray-500 truncate dark:text-gray-400">
                                                    {{ \Carbon\Carbon::parse($ticket->ticket_created)->format('jS F Y H:i') }}
                                                </p>
                                                </p>
                                            </div>
                                            <div class="inline-flex items-center text-base font-semibold text-gray-900 dark:text-white">
                                            <div class="text-center w-full whitespace-nowrap">
                                                <div class="{{ $ticket->status->colour() }} {{ $ticket->status->textcolour() }} text-xs font-medium me-2 px-2.5 py-0.5 rounded-sm  min-w-28 text-center">
                                                    {{ $ticket->status->label() }}
                                                </div>
                                            </div>
                                        </div>
                                    </li>
                                @endforeach
                            @else
                                <div class="p-4 mb-4 text-sm text-blue-800 bg-blue-50 border border-blue-300 rounded-lg dark:shadow-sm dark:bg-gray-900 dark:text-white dark:border-neutral-700" role="alert">
                                    {{ __("Currently there aren't any tickets.") }}
                                </div>
                            @endif
                        </ul>
                    </div>
                </div>
                <!-- This shows the something. -->
                <div class="bg-white border border-neutral-200 rounded-lg shadow-sm p-8 dark:bg-gray-900 dark:border-neutral-700">
                    <div class="flex items-center justify-between mb-4">
                        <h5 class="text-xl font-bold leading-none text-gray-900 dark:text-white">
                            Priority Tickets
                        </h5>
                    </div>
                    <div class="flow-root">
                        <ul role="list" class="divide-y divide-gray-200 dark:divide-gray-700">
                            @if($priorities_count  != '0')
                                @foreach( $priorities as $priority)
                                    <li class="py-3">
                                        <div class="flex items-center">
                                            <div class="flex-1 min-w-0">
                                                <a href="./tickets/show/{{ $priority->ticket_id }}">
                                                    <p class="text-sm font-medium text-gray-900 truncate dark:text-white">
                                                        {{ Str::limit($priority->subject,28, preserveWords: true) }}
                                                    </p>
                                                </a>
                                                <p class="text-sm text-gray-500 truncate dark:text-gray-400">
                                                    {{ \Carbon\Carbon::parse($priority->ticket_created)->format('jS F Y H:i') }}
                                                </p>
                                            </div>
                                            <div class="inline-flex items-center text-base font-semibold text-gray-900 dark:text-white">
                                                <div class="text-center w-full whitespace-nowrap">
                                                    <div class="{{ $priority->status->colour() }} {{ $priority->status->textcolour() }} text-xs font-medium me-2 px-2.5 py-0.5 rounded-sm  min-w-28 text-center">
                                                        {{ $priority->status->label() }}
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </li>
                                @endforeach
                            @else
                            <li>
                                <div class="p-4 mb-4 text-sm text-blue-800 bg-blue-50 border border-blue-300 rounded-lg dark:shadow-sm dark:bg-gray-900 dark:text-white dark:border-neutral-700" role="alert">
                                    {{ __("Currently there are no priority tickets.") }}
                                </div>
                            </li>
                            @endif
                        </ul>
                    </div>
                </div>
            </div>
    @else
        @hasanyrole('customer')
            <x-customers />
        @else
            <x-welcome />
        @endhasanyrole
    @endhasanyrole
</div>
