<div wire:poll.visible class="grid grid-cols-1 gap-4">
    <ul class="space-y-2 font-medium list">
        @if(count($categories) > '0')
            @hasanyrole('superadmin|employee|admin')
                @foreach($categories as $category)
                    <li class="list-row text-black dark:text-white">
                        <div class="w-70">
                            <a href="@if($category->uri){{ route('view_categories',[$category->uri]) }}@else # @endif">
                                <div class="text-md mt-2">{{ $category->category_name }}</div>
                            </a>
                        </div>
                    </li>
                @endforeach
            @else
                @foreach($categories as $category)
                    @if($category->display != '0')
                        <li class="list-row text-black dark:text-white">
                            <div>
                                <a href="@if($category->uri){{ route('view_categories',[$category->uri]) }}@else # @endif">
                                    <div class="text-md mt-2">{{ $category->category_name }}</div>
                                </a>
                                <!--<div class="text-xs uppercase font-semibold opacity-60">-</div>-->
                            </div>
                        </li>
                    @endif
                @endforeach
            @endhasanyrole
        @else
            <li>
                <div class="p-4 text-sm text-blue-800 bg-blue-50 border border-blue-300 rounded-lg dark:shadow-sm dark:bg-gray-900 dark:text-white dark:border-neutral-700" role="alert">
                    {{ __("Currently there aren't any categories.") }}
                </div>
            </li>
        @endif
    </ul>

</div>
