<div>
    <style>
        /* Mobile responsive table */
        @media (max-width: 768px) {
            /* Enable horizontal scrolling on mobile */
            .fi-ta-table {
                overflow-x: auto !important;
                -webkit-overflow-scrolling: touch !important;
            }

            /* Make table fit content */
            .fi-ta table {
                width: auto !important;
                min-width: 100% !important;
            }

            /* Reduce padding in table cells on mobile */
            .fi-ta-cell,
            .fi-ta-header-cell {
                padding: 0.5rem !important;
            }

            /* Stack action buttons vertically on mobile */
            .fi-ta-actions {
                display: flex !important;
                flex-direction: column !important;
                gap: 0.25rem !important;
                min-width: 100px !important;
            }

            .fi-ta-actions button {
                width: 100% !important;
                justify-content: center !important;
            }

            /* Adjust extension name column width - much wider on mobile */
            /* Target the cell containing the text item (extension name/description) */
            .fi-ta tbody td:has(.fi-ta-text-item),
            .fi-ta thead th:nth-child(2) {
                min-width: 280px !important;
                max-width: 100% !important;
                width: 100% !important;
            }

            /* Fallback for browsers that don't support :has() */
            .fi-ta tbody td:nth-child(2),
            .fi-ta thead th:nth-child(2) {
                min-width: 280px !important;
                max-width: 100% !important;
                width: 100% !important;
            }

            /* Remove the extension-description-wrapper hiding - let it show but constrained */
            .extension-description-wrapper {
                display: block !important;
                max-width: 100% !important;
                font-size: 0.75rem !important;
                line-height: 1.3 !important;
                margin-top: 0.25rem !important;
                overflow: hidden !important;
                text-overflow: ellipsis !important;
                display: -webkit-box !important;
                -webkit-line-clamp: 2 !important;
                -webkit-box-orient: vertical !important;
                color: rgb(107, 114, 128) !important; /* gray-500 for light mode */
            }

            /* Dark mode color for description */
            .dark .extension-description-wrapper {
                color: rgb(156, 163, 175) !important; /* gray-400 for dark mode */
            }

            /* Make version badges smaller on mobile */
            .fi-ta tbody td .fi-badge {
                font-size: 0.75rem !important;
                padding: 0.25rem 0.5rem !important;
            }
        }

        /* Hide Select all and Deselect all links */
        .fi-ta-select-all {
            display: none !important;
        }

        /* Hide column toggle button completely */
        button[aria-label="Toggle columns"],
        [data-dropdown-toggle="column-toggle"],
        .fi-ta-header-ctn button[x-data*="toggle"],
        button.fi-table-column-toggle-trigger {
            display: none !important;
        }

        /* Style the Apply columns button to indigo - override orange */
        .fi-dropdown-panel button[type="submit"],
        .fi-dropdown-panel .fi-btn,
        .fi-dropdown-panel button.fi-btn,
        [x-data*="toggleColumns"] button[type="submit"],
        button[type="submit"].fi-btn,
        .fi-ta-actions button[type="submit"] {
            background-color: rgb(67, 56, 202) !important;
            color: white !important;
            border-color: rgb(67, 56, 202) !important;
        }

        .fi-dropdown-panel button[type="submit"]:hover,
        .fi-dropdown-panel .fi-btn:hover,
        .fi-dropdown-panel button.fi-btn:hover,
        [x-data*="toggleColumns"] button[type="submit"]:hover,
        button[type="submit"].fi-btn:hover,
        .fi-ta-actions button[type="submit"]:hover {
            background-color: rgb(99, 102, 241) !important;
            border-color: rgb(99, 102, 241) !important;
        }

        /* Override Reset button - RED TEXT like customer page */
        button[class*="bg-orange"],
        button[class*="bg-amber"],
        button[class*="bg-red"],
        .bg-orange-600,
        .bg-amber-600,
        .bg-red-600,
        .fi-dropdown-panel button[class*="danger"],
        .fi-dropdown-panel button[class*="warning"],
        [x-data*="toggleColumns"] button:not([type="submit"]),
        [x-data*="toggleColumns"] a,
        button.fi-btn-color-danger,
        a.fi-btn-color-danger,
        button.fi-btn-color-warning,
        a.fi-btn-color-warning,
        [x-data*="toggleColumns"] button[style*="background"],
        [x-data*="toggleColumns"] a[style*="background"] {
            background: transparent !important;
            background-color: transparent !important;
            color: rgb(239, 68, 68) !important; /* RED text */
            border: none !important;
        }

        /* Hover state - NO background, just keep red text */
        button[class*="bg-orange"]:hover,
        button[class*="bg-amber"]:hover,
        button[class*="bg-red"]:hover,
        .fi-dropdown-panel button[class*="danger"]:hover,
        .fi-dropdown-panel button[class*="warning"]:hover,
        [x-data*="toggleColumns"] button:not([type="submit"]):hover,
        [x-data*="toggleColumns"] a:hover,
        button.fi-btn-color-danger:hover,
        a.fi-btn-color-danger:hover,
        button.fi-btn-color-warning:hover,
        a.fi-btn-color-warning:hover,
        [x-data*="toggleColumns"] button[style*="background"]:hover,
        [x-data*="toggleColumns"] a[style*="background"]:hover {
            background: transparent !important;
            background-color: transparent !important;
            color: rgb(239, 68, 68) !important; /* Keep same red text */
        }

        /* Reduce gap between bulk action buttons */
        .fi-ta-header-toolbar {
            gap: 3px !important;
        }

        /* Make checkboxes more visible with indigo - override Filament defaults */
        input[type="checkbox"],
        input[type="checkbox"].fi-checkbox-input {
            accent-color: #6366f1 !important;
            color: #6366f1 !important;
            width: 20px !important;
            height: 20px !important;
            cursor: pointer !important;
            border-radius: 4px !important;
        }

        /* Thicker border for unchecked checkboxes */
        input[type="checkbox"]:not(:checked),
        input[type="checkbox"].fi-checkbox-input:not(:checked) {
            border: 1.5px solid #d1d5db !important;
        }

        .fi-ta-checkbox {
            opacity: 1 !important;
        }

        .fi-ta-cell-checkbox {
            padding: 0.75rem !important;
        }

        /* Keep extension title on one line with smaller width */
        .fi-ta-text-item-label {
            max-width: 300px !important;
            overflow: hidden !important;
            text-overflow: ellipsis !important;
            white-space: nowrap !important;
        }

        /* Force ALL table text to be wrappable by default */
        .fi-ta tbody td * {
            white-space: normal !important;
        }

        /* Then specifically constrain extension titles to one line */
        .fi-ta-text-item-label,
        .fi-ta tbody td .font-bold,
        .fi-ta tbody td .font-medium,
        .fi-ta tbody td .text-lg {
            white-space: nowrap !important;
        }

        /* Style descriptions (gray text) with 2-line limit - DESKTOP/TABLET ONLY */
        @media (min-width: 769px) {
            .extension-description-wrapper {
                max-width: 500px !important;
                font-size: 0.875rem !important;
                line-height: 1.5 !important;
                overflow: hidden !important;
                display: -webkit-box !important;
                -webkit-line-clamp: 2 !important;
                -webkit-box-orient: vertical !important;
                white-space: normal !important;
                color: rgb(107, 114, 128) !important; /* gray-500 for light mode */
            }

            .dark .extension-description-wrapper {
                color: rgb(156, 163, 175) !important; /* gray-400 for dark mode */
            }
        }

        /* Use indigo for table row selection border - override orange */
        .fi-ta-row[aria-selected="true"],
        tr[aria-selected="true"],
        .fi-ta-row-selected,
        [aria-selected="true"],
        .fi-ta-row.fi-selected,
        .fi-ta-row.fi-selected > :first-child::before {
            border-left-color: #6366f1 !important;
            border-inline-start-color: #6366f1 !important;
            background-color: rgba(99, 102, 241, 0.05) !important;
        }

        /* Override any orange/primary colors in table */
        .fi-ta-row.fi-selected > :first-child::before {
            background-color: #6366f1 !important;
        }

        /* Extension action buttons */
        .fi-ta-actions button {
            margin-right: 0.25rem;
        }

        /* Make primary/indigo buttons with white icons */
        button[class*="fi-color-primary"],
        button.bg-indigo-600,
        button[class*="bg-indigo"],
        .bg-indigo-700,
        [class*="bg-indigo"],
        button[style*="background-color: rgb(67, 56, 202)"],
        button[style*="background-color: rgb(99, 102, 241)"] {
            background-color: rgb(99, 102, 241) !important;
            color: white !important;
        }

        button[class*="fi-color-primary"]:hover,
        button.bg-indigo-600:hover,
        button[class*="bg-indigo"]:hover,
        button[style*="background-color: rgb(67, 56, 202)"]:hover,
        button[style*="background-color: rgb(99, 102, 241)"]:hover {
            background-color: rgb(67, 56, 202) !important;
        }

        button[class*="fi-color-primary"] svg,
        button[class*="fi-color-primary"] svg path,
        button.bg-indigo-600 svg,
        button.bg-indigo-600 svg path,
        button[class*="bg-indigo"] svg,
        button[class*="bg-indigo"] svg path,
        .bg-indigo-700 svg,
        .bg-indigo-700 svg path,
        [class*="bg-indigo"] svg,
        [class*="bg-indigo"] svg path,
        button[style*="background-color: rgb(67, 56, 202)"] svg,
        button[style*="background-color: rgb(67, 56, 202)"] svg path,
        button[style*="background-color: rgb(99, 102, 241)"] svg,
        button[style*="background-color: rgb(99, 102, 241)"] svg path {
            color: white !important;
            fill: none !important;
            stroke: white !important;
            stroke-width: 2 !important;
        }

        /* Make success buttons green with white icons */
        button[class*="fi-color-success"],
        button.bg-green-600,
        button[style*="background-color: rgb(34, 197, 94)"] {
            background-color: rgb(34, 197, 94) !important;
            color: white !important;
        }

        button[class*="fi-color-success"]:hover,
        button.bg-green-600:hover,
        button[style*="background-color: rgb(34, 197, 94)"]:hover {
            background-color: rgb(22, 163, 74) !important;
        }

        button[class*="fi-color-success"] svg,
        button[class*="fi-color-success"] svg path,
        button.bg-green-600 svg,
        button.bg-green-600 svg path,
        button[style*="background-color: rgb(34, 197, 94)"] svg,
        button[style*="background-color: rgb(34, 197, 94)"] svg path {
            color: white !important;
            fill: none !important;
            stroke: white !important;
            stroke-width: 2 !important;
        }

        /* Make warning buttons orange turned to RED with white icons */
        button[class*="fi-color-warning"],
        button.bg-orange-600,
        button[style*="background-color: rgb(249, 115, 22)"] {
            background-color: rgb(239, 68, 68) !important;
            color: white !important;
        }

        button[class*="fi-color-warning"]:hover,
        button.bg-orange-600:hover,
        button[style*="background-color: rgb(249, 115, 22)"]:hover {
            background-color: rgb(220, 38, 38) !important;
        }

        button[class*="fi-color-warning"] svg,
        button[class*="fi-color-warning"] svg path,
        button.bg-orange-600 svg,
        button.bg-orange-600 svg path,
        button[style*="background-color: rgb(249, 115, 22)"] svg,
        button[style*="background-color: rgb(249, 115, 22)"] svg path {
            color: white !important;
            fill: none !important;
            stroke: white !important;
            stroke-width: 2 !important;
        }

        /* Make danger buttons red with white icons */
        button[class*="fi-color-danger"],
        button.bg-red-600,
        button[style*="background-color: rgb(239, 68, 68)"] {
            background-color: rgb(239, 68, 68) !important;
            color: white !important;
        }

        button[class*="fi-color-danger"]:hover,
        button.bg-red-600:hover,
        button[style*="background-color: rgb(239, 68, 68)"]:hover {
            background-color: rgb(220, 38, 38) !important;
        }

        button[class*="fi-color-danger"] svg,
        button[class*="fi-color-danger"] svg path,
        button.bg-red-600 svg,
        button.bg-red-600 svg path,
        button[style*="background-color: rgb(239, 68, 68)"] svg,
        button[style*="background-color: rgb(239, 68, 68)"] svg path {
            color: white !important;
            fill: none !important;
            stroke: white !important;
            stroke-width: 2 !important;
        }

        /* Make info/View Details buttons cyan/blue with white icons */
        button[class*="fi-color-info"],
        button.bg-cyan-600,
        button[style*="background-color: rgb(8, 145, 178)"] {
            background-color: rgb(8, 145, 178) !important;
            color: white !important;
        }

        button[class*="fi-color-info"]:hover,
        button.bg-cyan-600:hover,
        button[style*="background-color: rgb(8, 145, 178)"]:hover {
            background-color: rgb(14, 116, 144) !important;
        }

        button[class*="fi-color-info"] svg,
        button[class*="fi-color-info"] svg path,
        button.bg-cyan-600 svg,
        button.bg-cyan-600 svg path,
        button[style*="background-color: rgb(8, 145, 178)"] svg,
        button[style*="background-color: rgb(8, 145, 178)"] svg path {
            color: white !important;
            fill: none !important;
            stroke: white !important;
            stroke-width: 2 !important;
        }

        /* Style submit buttons to indigo */
        .fi-modal button[type="submit"],
        .fi-modal .fi-btn-primary {
            background-color: rgb(67, 56, 202) !important;
            color: white !important;
            border-color: rgb(67, 56, 202) !important;
        }

        .fi-modal button[type="submit"]:hover,
        .fi-modal .fi-btn-primary:hover {
            background-color: rgb(99, 102, 241) !important;
            border-color: rgb(99, 102, 241) !important;
        }

        /* Ensure all table action buttons have white icons and text */
        .fi-ta-actions button svg,
        .fi-ta-actions button svg path,
        .fi-ac-btn-action svg,
        .fi-ac-btn-action svg path {
            stroke: currentColor !important;
        }

        /* Fix row action buttons - Enable button */
        .fi-ta-actions .fi-btn[class*="success"] svg,
        .fi-ta-actions .fi-btn[class*="success"] svg path {
            color: white !important;
            stroke: white !important;
        }

        /* Fix row action buttons - Uninstall button */
        .fi-ta-actions .fi-btn[class*="danger"] svg,
        .fi-ta-actions .fi-btn[class*="danger"] svg path {
            color: white !important;
            stroke: white !important;
        }
    </style>

    {{ $this->table }}

    <x-filament-actions::modals />
</div>
