<div wire:poll.visible>
    <form wire:submit="create">
        <div class="mt-3">
            <flux:input label="Announcement Title" wire:model="title" />
        </div>
        <div class="mt-3">
            <flux:input label="Announcement URI" badge="Optional" description="{{ config('app.url') }}/id/{{ Str::of($slug ?: $title)->slug('-') }}" placeholder="announcement-uri" wire:model="slug" />
        </div>
        <div class="mt-3">
            <flux:input label="Cover Image" badge="Optional" placeholder="You can display an image for the announcement." wire:model="image" />
        </div>
        <div class="mt-3">
            <flux:textarea rows="auto" label="Content" wire:model="content" />
        </div>
        <div class="mt-3">
            <flux:select label="Category" wire:model="parent_category" >
                <flux:select.option>-</flux:select.option>
                @foreach($categories as $category)
                    <flux:select.option wire:key="{{ $category->id }}" value="{{ $category->id }}">{{ $category->category_name }}</flux:select.option>
                @endforeach
            </flux:select>
        </div>
        <div class="grid grid-cols-2 gap-4 mt-3">
            <flux:select label="Draft" placeholder="Draft or Publish the announcement?" wire:model="draft" >
                <flux:select.option>-</flux:select.option>
                <flux:select.option wire:key="1" value="1">Draft</flux:select.option>
                <flux:select.option wire:key="0" value="0">Publish</flux:select.option>
            </flux:select>
            
            <flux:select label="Private" placeholder="Private for Customers or Public?" wire:model="private" >
                <flux:select.option>-</flux:select.option>
                <flux:select.option wire:key="0" value="0">Public</flux:select.option>
                <flux:select.option wire:key="1" value="1">Private</flux:select.option>
            </flux:select>
        </div>
        <flux:button class="!bg-indigo-700 hover:!bg-indigo-500 !text-white mt-3" type="submit">{{ __("Create") }}</flux:button>
    </form>
</div>
