<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ config('app.name', 'Ticaga') }} Installer</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <style>
        [x-cloak] { display: none !important; }
    </style>
</head>
<body class="bg-slate-50 text-slate-900 dark:bg-slate-950 dark:text-slate-100">
    <div class="min-h-screen px-4 py-10 sm:px-6 lg:px-8">
        <div class="mx-auto w-full max-w-4xl space-y-10">
            @php
                $stepKeys = array_map(fn ($step) => $step['key'], $steps);
                $currentIndex = array_search($currentStep, $stepKeys, true);
                $requirementsPassed = collect($requirements)->every(fn ($requirement) => ($requirement['blocking'] ?? true) === false ? true : ($requirement['passed'] ?? false));
                $dependenciesPassed = collect($dependencies)->every(fn ($dependency) => $dependency['passed'] ?? false);
            @endphp

            <header class="space-y-6">
                <div>
                    <h1 class="text-3xl font-bold tracking-tight">Welcome to the {{ config('app.name', 'Ticaga') }} installer</h1>
                    <p class="mt-2 text-base text-slate-600 dark:text-slate-300">
                        Follow the guided steps to prepare your environment, configure your database, and create the first superadmin account.
                    </p>
                </div>

                <nav aria-label="Progress">
                    <ol class="flex flex-col gap-4 sm:flex-row sm:flex-wrap sm:items-center sm:gap-3">
                        @foreach ($steps as $step)
                            @php
                                $isActive = $step['current'];
                                $isCompleted = $step['completed'];
                                $isClickable = $isCompleted || $isActive || $stepKeys[$loop->index] === 'requirements';
                            @endphp
                            <li class="flex flex-col gap-2 sm:flex-row sm:items-center sm:gap-3">
                                @if ($isClickable)
                                    <a
                                        @class([
                                            'flex h-10 min-w-[2.5rem] items-center justify-center rounded-full border text-sm font-medium transition mx-auto sm:mx-0',
                                            'border-emerald-500 bg-emerald-500 text-white' => $isCompleted,
                                            'border-slate-900/10 bg-white text-slate-900 dark:border-slate-700 dark:bg-slate-900 dark:text-white' => $isActive && ! $isCompleted,
                                            'border-slate-200 bg-slate-100 text-slate-500 dark:border-slate-800 dark:bg-slate-800 dark:text-slate-400' => ! $isActive && ! $isCompleted,
                                        ])
                                        href="{{ route('install.show', ['step' => $step['key']]) }}"
                                    >
                                        @if ($isCompleted)
                                            <span class="text-base">&#10003;</span>
                                        @else
                                            <span>{{ $loop->iteration }}</span>
                                        @endif
                                    </a>
                                @else
                                    <span
                                        @class([
                                            'flex h-10 min-w-[2.5rem] items-center justify-center rounded-full border text-sm font-medium mx-auto sm:mx-0',
                                            'border-slate-200 bg-slate-100 text-slate-400 dark:border-slate-800 dark:bg-slate-900 dark:text-slate-600',
                                        ])
                                    >
                                        {{ $loop->iteration }}
                                    </span>
                                @endif
                                <span class="text-center text-sm font-medium text-slate-600 dark:text-slate-300 sm:text-left">{{ $step['label'] }}</span>
                                @if (! $loop->last)
                                    <span class="hidden text-slate-300 dark:text-slate-700 sm:inline">&rsaquo;</span>
                                @endif
                            </li>
                        @endforeach
                    </ol>
                </nav>
            </header>

            @if (session('status'))
                <div class="rounded-lg border border-emerald-200 bg-emerald-50 p-4 text-emerald-800 dark:border-emerald-900/40 dark:bg-emerald-950/40 dark:text-emerald-200">
                    {{ session('status') }}
                </div>
            @endif

            @if ($errors->any())
                <div class="rounded-lg border border-rose-200 bg-rose-50 p-4 text-rose-700 dark:border-rose-900/40 dark:bg-rose-950/40 dark:text-rose-200">
                    <h2 class="text-sm font-semibold">We encountered some issues</h2>
                    <ul class="mt-3 list-disc space-y-1 pl-5 text-sm">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <main class="space-y-8">
                @if ($currentStep === 'requirements')
                    <section class="space-y-6">
                        <h2 class="text-xl font-semibold">System requirements</h2>
                        <p class="text-sm text-slate-600 dark:text-slate-300">
                            Ensure that the server meets the minimum software requirements. Blocking issues must be resolved before continuing. Warnings highlight optional enhancements.
                        </p>

                        <div class="space-y-4">
                            @foreach ($requirements as $requirement)
                                @php
                                    $passed = $requirement['passed'] ?? false;
                                    $status = $requirement['status'] ?? ($passed ? 'passed' : 'failed');
                                    $blocking = $requirement['blocking'] ?? true;
                                    $badgeClasses = [
                                        'inline-flex items-center rounded-full px-3 py-1 text-xs font-medium',
                                        'bg-emerald-100 text-emerald-700 dark:bg-emerald-900/40 dark:text-emerald-200' => $passed,
                                        'bg-amber-100 text-amber-700 dark:bg-amber-900/40 dark:text-amber-200' => (! $passed && ! $blocking) || $status === 'warning',
                                        'bg-sky-100 text-sky-700 dark:bg-sky-900/40 dark:text-sky-200' => $status === 'pending',
                                        'bg-rose-100 text-rose-700 dark:bg-rose-900/40 dark:text-rose-200' => ! $passed && $blocking && $status !== 'pending' && $status !== 'warning',
                                    ];
                                @endphp
                                <div class="rounded-lg border border-slate-200 bg-white p-5 shadow-sm dark:border-slate-800 dark:bg-slate-900">
                                    <div class="flex flex-wrap items-start justify-between gap-3">
                                        <div>
                                            <p class="text-sm font-semibold">{{ $requirement['label'] }}</p>
                                            <p class="mt-1 text-sm text-slate-600 dark:text-slate-300">{{ $requirement['details'] }}</p>
                                        </div>
                                        <span @class($badgeClasses)>
                                            @if ($passed)
                                                Ready
                                            @elseif ($status === 'pending')
                                                Pending
                                            @elseif ($status === 'warning' || ! $blocking)
                                                Warning
                                            @else
                                                Needs attention
                                            @endif
                                        </span>
                                    </div>
                                </div>
                            @endforeach
                        </div>

                        <form method="POST" action="{{ route('install.handle', ['step' => 'requirements']) }}" class="flex flex-col items-stretch gap-3 sm:flex-row sm:justify-end">
                            @csrf
                            <button type="submit" @class(['inline-flex items-center justify-center rounded-md bg-emerald-600 px-4 py-2 text-sm font-semibold text-white shadow-sm transition hover:bg-emerald-700 focus:outline-none focus:ring-2 focus:ring-emerald-500 focus:ring-offset-2 disabled:cursor-not-allowed disabled:opacity-50 w-full sm:w-auto']) @disabled(! $requirementsPassed)>
                                Continue
                            </button>
                        </form>
                    </section>
                @elseif ($currentStep === 'dependencies')
                    <section class="space-y-6">
                        <h2 class="text-xl font-semibold">Install application dependencies</h2>
                        <p class="text-sm text-slate-600 dark:text-slate-300">
                            Composer and Node dependencies are required for the application to run correctly. Install them automatically or ensure they are already available.
                        </p>

                        <div class="space-y-4">
                            @foreach ($dependencies as $dependency)
                                @php
                                    $passed = $dependency['passed'] ?? false;
                                    $status = $dependency['status'] ?? ($passed ? 'passed' : 'failed');
                                    $badgeClasses = [
                                        'inline-flex items-center rounded-full px-3 py-1 text-xs font-medium',
                                        'bg-emerald-100 text-emerald-700 dark:bg-emerald-900/40 dark:text-emerald-200' => $status === 'passed',
                                        'bg-sky-100 text-sky-700 dark:bg-sky-900/40 dark:text-sky-200' => $status === 'pending',
                                        'bg-rose-100 text-rose-700 dark:bg-rose-900/40 dark:text-rose-200' => $status === 'failed',
                                    ];
                                    $label = match ($status) {
                                        'passed' => 'Installed',
                                        'pending' => 'Pending',
                                        default => 'Missing',
                                    };
                                @endphp
                                <div class="rounded-lg border border-slate-200 bg-white p-5 shadow-sm dark:border-slate-800 dark:bg-slate-900">
                                    <div class="flex flex-wrap items-start justify-between gap-3">
                                        <div>
                                            <p class="text-sm font-semibold">{{ $dependency['label'] }}</p>
                                            <p class="mt-1 text-sm text-slate-600 dark:text-slate-300">{{ $dependency['details'] }}</p>
                                        </div>
                                        <span @class($badgeClasses)>
                                            {{ $label }}
                                        </span>
                                    </div>
                                </div>
                            @endforeach
                        </div>

                        <form method="POST" action="{{ route('install.handle', ['step' => 'dependencies']) }}" class="flex flex-col gap-4 sm:flex-row sm:items-center sm:justify-between" x-data="{ installing: false }" @submit="if ($event.submitter.value === 'install') { installing = true }">
                            @csrf
                            <div class="flex flex-col gap-3 sm:flex-row">
                                @if (! $dependenciesPassed)
                                    <button type="submit" name="action" value="install" class="inline-flex items-center justify-center rounded-md border border-slate-300 bg-white px-4 py-2 text-sm font-semibold text-slate-700 shadow-sm transition hover:bg-slate-50 focus:outline-none focus:ring-2 focus:ring-emerald-500 focus:ring-offset-2 dark:border-slate-700 dark:bg-slate-900 dark:text-slate-100 dark:hover:bg-slate-800 w-full sm:w-auto disabled:opacity-50 disabled:cursor-not-allowed" :disabled="installing">
                                        <span x-show="!installing" x-cloak>Install automatically</span>
                                        <span style="display: none;" x-show="installing" x-cloak class="flex items-center gap-2">
                                            <svg class="animate-spin h-4 w-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                                                <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                                                <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                                            </svg>
                                            Installing... (this may take several minutes)
                                        </span>
                                    </button>
                                @endif
                            </div>
                            <div class="flex flex-col gap-3 sm:flex-row sm:items-center">
                                <a href="{{ route('install.show', ['step' => 'requirements']) }}" class="w-full text-center text-sm font-medium text-slate-500 transition hover:text-slate-700 dark:text-slate-400 dark:hover:text-slate-200 sm:w-auto sm:text-left">
                                    &larr; Back to requirements
                                </a>
                                <button type="submit" name="action" value="continue" @class(['inline-flex items-center justify-center rounded-md bg-emerald-600 px-4 py-2 text-sm font-semibold text-white shadow-sm transition hover:bg-emerald-700 focus:outline-none focus:ring-2 focus:ring-emerald-500 focus:ring-offset-2 disabled:cursor-not-allowed disabled:opacity-50 w-full sm:w-auto']) @disabled(! $dependenciesPassed)>
                                    Continue
                                </button>
                            </div>
                        </form>
                    </section>
                @elseif ($currentStep === 'database')
                    <section class="space-y-6">
                        <h2 class="text-xl font-semibold">Connect to your MySQL database</h2>
                        <p class="text-sm text-slate-600 dark:text-slate-300">
                            Provide the connection details for the MySQL database that will store your Ticaga data. These credentials will be written to the environment configuration file.
                        </p>

                        @if ($connectionStatus['connected'])
                            <div class="rounded-lg border border-emerald-200 bg-emerald-50 p-4 text-sm text-emerald-700 dark:border-emerald-900/40 dark:bg-emerald-950/40 dark:text-emerald-200">
                                A database connection is currently available. If you need to switch databases, update the details below.
                            </div>
                        @elseif ($connectionStatus['error'])
                            <div class="rounded-lg border border-amber-200 bg-amber-50 p-4 text-sm text-amber-700 dark:border-amber-900/40 dark:bg-amber-950/40 dark:text-amber-200">
                                {{ $connectionStatus['error'] }}
                            </div>
                        @endif

                        <form method="POST" action="{{ route('install.handle', ['step' => 'database']) }}" class="space-y-6">
                            @csrf
                            <div class="grid gap-6 sm:grid-cols-2">
                                <div class="space-y-2">
                                    <label for="db_host" class="text-sm font-medium text-slate-700 dark:text-slate-200">Database host</label>
                                    <input type="text" name="db_host" id="db_host" value="{{ old('db_host', $databaseData['db_host']) }}" required class="block w-full rounded-md border-slate-300 shadow-sm focus:border-emerald-500 focus:ring-emerald-500 dark:border-slate-700 dark:bg-slate-900 dark:text-slate-100" />
                                </div>
                                <div class="space-y-2">
                                    <label for="db_port" class="text-sm font-medium text-slate-700 dark:text-slate-200">Port</label>
                                    <input type="number" name="db_port" id="db_port" value="{{ old('db_port', $databaseData['db_port']) }}" min="1" max="65535" required class="block w-full rounded-md border-slate-300 shadow-sm focus:border-emerald-500 focus:ring-emerald-500 dark:border-slate-700 dark:bg-slate-900 dark:text-slate-100" />
                                </div>
                                <div class="space-y-2">
                                    <label for="db_name" class="text-sm font-medium text-slate-700 dark:text-slate-200">Database name</label>
                                    <input type="text" name="db_name" id="db_name" value="{{ old('db_name', $databaseData['db_name']) }}" required class="block w-full rounded-md border-slate-300 shadow-sm focus:border-emerald-500 focus:ring-emerald-500 dark:border-slate-700 dark:bg-slate-900 dark:text-slate-100" />
                                </div>
                                <div class="space-y-2">
                                    <label for="db_username" class="text-sm font-medium text-slate-700 dark:text-slate-200">Database username</label>
                                    <input type="text" name="db_username" id="db_username" value="{{ old('db_username', $databaseData['db_username']) }}" required class="block w-full rounded-md border-slate-300 shadow-sm focus:border-emerald-500 focus:ring-emerald-500 dark:border-slate-700 dark:bg-slate-900 dark:text-slate-100" />
                                </div>
                                <div class="space-y-2 sm:col-span-2">
                                    <label for="db_password" class="text-sm font-medium text-slate-700 dark:text-slate-200">Database password</label>
                                    <input type="password" name="db_password" id="db_password" value="" class="block w-full rounded-md border-slate-300 shadow-sm focus:border-emerald-500 focus:ring-emerald-500 dark:border-slate-700 dark:bg-slate-900 dark:text-slate-100" />
                                    <p class="text-xs text-slate-500 dark:text-slate-400">Leave blank to keep the stored password if it has already been provided.</p>
                                </div>
                            </div>

                            <div class="flex flex-col gap-3 sm:flex-row sm:items-center sm:justify-between">
                                <a href="{{ route('install.show', ['step' => 'dependencies']) }}" class="w-full text-center text-sm font-medium text-slate-500 transition hover:text-slate-700 dark:text-slate-400 dark:hover:text-slate-200 sm:w-auto sm:text-left">
                                    &larr; Back to dependencies
                                </a>
                                <button type="submit" class="inline-flex items-center justify-center rounded-md bg-emerald-600 px-4 py-2 text-sm font-semibold text-white shadow-sm transition hover:bg-emerald-700 focus:outline-none focus:ring-2 focus:ring-emerald-500 focus:ring-offset-2 w-full sm:w-auto">
                                    Continue
                                </button>
                            </div>
                        </form>
                    </section>
                @elseif ($currentStep === 'application')
                    <section class="space-y-6">
                        <h2 class="text-xl font-semibold">Configure application settings</h2>
                        <p class="text-sm text-slate-600 dark:text-slate-300">
                            Set the URL that users will use to reach Ticaga. A trial license will be automatically requested and activated when you continue.
                        </p>

                        <div class="rounded-lg border border-blue-200 bg-blue-50 p-4 text-sm text-blue-700 dark:border-blue-900/40 dark:bg-blue-950/40 dark:text-blue-200">
                            <div class="flex">
                                <div class="flex-shrink-0">
                                    <svg class="h-5 w-5 text-blue-400" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd" />
                                    </svg>
                                </div>
                                <div class="ml-3">
                                    <p class="font-semibold">Trial License Information</p>
                                    <p class="mt-1">When you click "Continue", Ticaga will automatically contact our licensing server to request a trial license for your installation. This requires an active internet connection.</p>
                                </div>
                            </div>
                        </div>

                        <form method="POST" action="{{ route('install.handle', ['step' => 'application']) }}" class="space-y-6">
                            @csrf
                            <div class="space-y-4">
                                <div class="space-y-2">
                                    <label for="app_url" class="text-sm font-medium text-slate-700 dark:text-slate-200">Ticaga URL</label>
                                    <input type="url" name="app_url" id="app_url" value="{{ old('app_url', $applicationData['app_url']) }}" required class="block w-full rounded-md border-slate-300 shadow-sm focus:border-emerald-500 focus:ring-emerald-500 dark:border-slate-700 dark:bg-slate-900 dark:text-slate-100" />
                                    <p class="text-xs text-slate-500 dark:text-slate-400">The full URL where Ticaga will be accessible (e.g., https://support.yourcompany.com)</p>
                                </div>
                            </div>

                            <div class="flex flex-col gap-3 sm:flex-row sm:items-center sm:justify-between">
                                <a href="{{ route('install.show', ['step' => 'database']) }}" class="w-full text-center text-sm font-medium text-slate-500 transition hover:text-slate-700 dark:text-slate-400 dark:hover:text-slate-200 sm:w-auto sm:text-left">
                                    &larr; Back to database
                                </a>
                                <button type="submit" class="inline-flex items-center justify-center rounded-md bg-emerald-600 px-4 py-2 text-sm font-semibold text-white shadow-sm transition hover:bg-emerald-700 focus:outline-none focus:ring-2 focus:ring-emerald-500 focus:ring-offset-2 w-full sm:w-auto">
                                    Continue &amp; request trial license
                                </button>
                            </div>
                        </form>
                    </section>
                @elseif ($currentStep === 'administrator')
                    <section class="space-y-6">
                        <h2 class="text-xl font-semibold">Create the first administrator</h2>
                        <p class="text-sm text-slate-600 dark:text-slate-300">
                            This account will receive the superadmin role and full access to Ticaga. Use a secure password and store the credentials safely.
                        </p>

                        <form method="POST" action="{{ route('install.handle', ['step' => 'administrator']) }}" class="space-y-6">
                            @csrf
                            <div class="grid gap-6 sm:grid-cols-2">
                                <div class="space-y-2">
                                    <label for="name" class="text-sm font-medium text-slate-700 dark:text-slate-200">Full name</label>
                                    <input type="text" name="name" id="name" value="{{ old('name') }}" required class="block w-full rounded-md border-slate-300 shadow-sm focus:border-emerald-500 focus:ring-emerald-500 dark:border-slate-700 dark:bg-slate-900 dark:text-slate-100" />
                                </div>
                                <div class="space-y-2">
                                    <label for="email" class="text-sm font-medium text-slate-700 dark:text-slate-200">Email address</label>
                                    <input type="email" name="email" id="email" value="{{ old('email') }}" required class="block w-full rounded-md border-slate-300 shadow-sm focus:border-emerald-500 focus:ring-emerald-500 dark:border-slate-700 dark:bg-slate-900 dark:text-slate-100" />
                                </div>
                                <div class="space-y-2">
                                    <label for="company" class="text-sm font-medium text-slate-700 dark:text-slate-200">Company (optional)</label>
                                    <input type="text" name="company" id="company" value="{{ old('company') }}" class="block w-full rounded-md border-slate-300 shadow-sm focus:border-emerald-500 focus:ring-emerald-500 dark:border-slate-700 dark:bg-slate-900 dark:text-slate-100" />
                                </div>
                                <div class="space-y-2">
                                    <label for="phone_number" class="text-sm font-medium text-slate-700 dark:text-slate-200">Phone number (optional)</label>
                                    <input type="text" name="phone_number" id="phone_number" value="{{ old('phone_number') }}" class="block w-full rounded-md border-slate-300 shadow-sm focus:border-emerald-500 focus:ring-emerald-500 dark:border-slate-700 dark:bg-slate-900 dark:text-slate-100" />
                                </div>
                                <div class="space-y-2">
                                    <label for="password" class="text-sm font-medium text-slate-700 dark:text-slate-200">Password</label>
                                    <input type="password" name="password" id="password" required class="block w-full rounded-md border-slate-300 shadow-sm focus:border-emerald-500 focus:ring-emerald-500 dark:border-slate-700 dark:bg-slate-900 dark:text-slate-100" />
                                    <p class="text-xs text-slate-500 dark:text-slate-400">Passwords must be at least 15 characters and include letters, numbers, and symbols.</p>
                                </div>
                                <div class="space-y-2">
                                    <label for="password_confirmation" class="text-sm font-medium text-slate-700 dark:text-slate-200">Confirm password</label>
                                    <input type="password" name="password_confirmation" id="password_confirmation" required class="block w-full rounded-md border-slate-300 shadow-sm focus:border-emerald-500 focus:ring-emerald-500 dark:border-slate-700 dark:bg-slate-900 dark:text-slate-100" />
                                </div>
                            </div>

                            <div class="flex flex-col gap-3 sm:flex-row sm:items-center sm:justify-between">
                                <a href="{{ route('install.show', ['step' => 'application']) }}" class="w-full text-center text-sm font-medium text-slate-500 transition hover:text-slate-700 dark:text-slate-400 dark:hover:text-slate-200 sm:w-auto sm:text-left">
                                    &larr; Back to application settings
                                </a>
                                <button type="submit" class="inline-flex items-center justify-center rounded-md bg-emerald-600 px-4 py-2 text-sm font-semibold text-white shadow-sm transition hover:bg-emerald-700 focus:outline-none focus:ring-2 focus:ring-emerald-500 focus:ring-offset-2 w-full sm:w-auto">
                                    Complete installation
                                </button>
                            </div>
                        </form>
                    </section>
                @endif
            </main>
        </div>
    </div>
</body>
</html>