<x-layouts.app :title="__('Dashboard')">
    @if(!Auth::guest() && Auth::user()->id == '1' && !auth()->user()->hasRole('superadmin'))
    <div class="flex w-full flex-1 flex-col gap-4 rounded-xl">
        <div id="alert-additional-content-2" class="p-4 mb-4 text-red-800 border border-red-300 rounded-lg bg-red-50 dark:bg-red-900 dark:text-white dark:border-red-800" role="alert">
            <div class="flex items-center">
                <h3 class="text-lg font-medium">Administrator Permissions</h3>
            </div>
            <div class="mt-2 mb-4 text-sm">
                Click the button to convert your account into an Administrator.
            </div>
            <div class="flex">
                <a href="{{ route('superadmin') }}" type="button" class="text-white bg-red-800 hover:bg-red-900 focus:ring-4 focus:outline-none focus:ring-red-300 font-medium rounded-lg text-xs px-3 py-1.5 me-2 text-center inline-flex items-center dark:bg-red-600 dark:hover:bg-red-700 dark:focus:ring-red-800">
                    Upgrade Account
                </a>
            </div>
        </div>
    </div>
    @endif
    
    <div class="flex w-full flex-1 flex-col gap-4 rounded-xl mt-5">
        @if(!Auth::guest())
            <livewire:partials.dashboard.statistics/>
        @endif

        <livewire:partials.dashboard.homepage/>

        <livewire:partials.dashboard.widgets :license_status="$license_status" :license="$license"/>
    </div>
</x-layouts.app>
