@php
    $sizeClasses = [
        'sm' => 'px-3 py-1.5 text-sm',
        'md' => 'px-4 py-2 text-base',
        'lg' => 'px-5 py-3 text-lg',
    ];

    $variantClasses = [
        'primary' => 'bg-indigo-600 hover:bg-indigo-700 text-white',
        'secondary' => 'bg-zinc-200 hover:bg-zinc-300 text-zinc-900 dark:bg-zinc-700 dark:hover:bg-zinc-600 dark:text-zinc-100',
        'danger' => 'bg-red-600 hover:bg-red-700 text-white',
    ];

    $classes = 'inline-flex items-center gap-2 font-medium rounded-lg transition-colors focus:outline-none focus:ring-2 focus:ring-offset-2';
    $classes .= ' ' . ($sizeClasses[$size] ?? $sizeClasses['md']);
    $classes .= ' ' . ($variantClasses[$variant] ?? $variantClasses['primary']);
@endphp

@if($href)
    <a href="{{ $href }}" wire:navigate {{ $attributes->merge(['class' => $classes]) }}>
        @if($icon)
            <x-ticaga-icon :name="$icon" class="w-5 h-5" />
        @endif
        {{ $slot }}
        @if($iconTrailing)
            <x-ticaga-icon :name="$iconTrailing" class="w-5 h-5" />
        @endif
    </a>
@else
    <button type="{{ $type }}" {{ $attributes->merge(['class' => $classes]) }}>
        @if($icon)
            <x-ticaga-icon :name="$icon" class="w-5 h-5" />
        @endif
        {{ $slot }}
        @if($iconTrailing)
            <x-ticaga-icon :name="$iconTrailing" class="w-5 h-5" />
        @endif
    </button>
@endif
