@props([
    'heading' => '',
    'subheading' => '',
    'fullWidth' => false,
])

<div class="flex items-start max-md:flex-col">
    <div class="me-10 w-full pb-4 md:w-[220px]">
        <flux:navlist>
            <flux:navlist.item :href="route('settings.profile')" wire:navigate>{{ __('Profile') }}</flux:navlist.item>
            <flux:navlist.item :href="route('settings.password')" wire:navigate>{{ __('Password') }}</flux:navlist.item>
            <flux:navlist.item :href="route('settings.appearance')" wire:navigate>{{ __('Appearance') }}</flux:navlist.item>
            <flux:navlist.item :href="route('settings.sessions')" wire:navigate>{{ __('Browser Sessions') }}</flux:navlist.item>
            @if (Laravel\Fortify\Features::canManageTwoFactorAuthentication())
                <flux:navlist.item :href="route('two-factor.show')" wire:navigate>{{ __('2FA Security') }}</flux:navlist.item>
            @endif
	        @if(Auth::user()->hasRole('superadmin'))
                <flux:navlist.item :href="route('settings.license')" wire:navigate>{{ __('License') }}</flux:navlist.item>
                <flux:navlist.item :href="route('settings.api-token')" wire:navigate>{{ __('API Details') }}</flux:navlist.item>
                <flux:navlist.item :href="route('settings.mail-settings')" wire:navigate>{{ __('Mail Settings') }}</flux:navlist.item>
                <flux:navlist.item :href="route('settings.attachment-settings')" wire:navigate>{{ __('Attachment Settings') }}</flux:navlist.item>
            @endif
            @if(Auth::user()->hasAnyRole(['superadmin', 'admin']))
                <flux:navlist.item :href="route('settings.categories')" wire:navigate>{{ __('Categories') }}</flux:navlist.item>
            @endif
        </flux:navlist>
    </div>

    <flux:separator class="md:hidden" />

    <div class="flex-1 self-stretch max-md:pt-6">
        <flux:heading>{{ $heading }}</flux:heading>
        <flux:subheading>{{ $subheading }}</flux:subheading>

        <div class="mt-5 w-full {{ $fullWidth ? '' : 'max-w-lg' }}">
            {{ $slot }}
        </div>
    </div>
</div>
