<x-layouts.app :title="__('Clients')">
    @php
        // Get online status
        $online_status = DB::table('sessions')
                            ->distinct()
                            ->select(['users.id', 'users.name'])
                            ->whereNotNull('user_id')
                            ->leftJoin('users', 'sessions.user_id', '=', 'users.id')
                            ->where('users.id', '=', $user->id)
                            ->first();

        // Prepare avatar
        if($user->profile_photo_path != '') {
            $avatar_src = config('app.url') . '/storage/' . $user->profile_photo_path;
        } else {
            $avatar_src = "https://gravatar.com/avatar/" . hash('sha256', strtolower(trim($user->email))) . ".png?s=1024";
        }

        $badge_color = $online_status ? 'green' : 'red';
    @endphp

    @if (session()->has('message'))
        <x-auth-session-status class="dark:text-green-200 mb-4" :status="session('message')" />
    @endif

    <!-- Client Info Card -->
    <div class="bg-white dark:bg-gray-900 border border-gray-200 dark:border-gray-700 rounded-xl shadow-sm overflow-hidden mb-6">
        <div class="p-6">
            <div class="space-y-4">
                <!-- Client Name with Avatar and Billing Link -->
                <div class="flex items-center justify-between gap-4">
                    <div class="flex items-center gap-4">
                        <!-- Profile Image with Status Badge -->
                        <flux:avatar
                            badge
                            badge:color="{{ $badge_color }}"
                            size="lg"
                            src="{{ $avatar_src }}"
                        />

                        <div class="flex-1">
                            <flux:heading size="lg">{{ $user->name }}</flux:heading>
                            @if($user->billing_system != '' && $user->billing_id != '')
                                <div class="flex items-center gap-2 mt-2">
                                    @if($user->billing_system == 'whmcs' && $user->billing_id != '')
                                        <flux:link href="{{ config('ticaga.whmcs') }}/admin/clientssummary.php?userid={{ $user->billing_id }}" target="_blank" class="inline-flex items-center text-sm">
                                            <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-4M14 4h6m0 0v6m0-6L10 14"></path>
                                            </svg>
                                            View in WHMCS
                                        </flux:link>
                                    @endif
                                    @if($user->billing_system == 'blesta' && $user->billing_id != '')
                                        <flux:link href="{{ config('ticaga.blesta') }}/clients/view/{{ $user->billing_id }}" target="_blank" class="inline-flex items-center text-sm">
                                            <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-4M14 4h6m0 0v6m0-6L10 14"></path>
                                            </svg>
                                            View in Blesta
                                        </flux:link>
                                    @endif
                                </div>
                            @endif
                        </div>
                    </div>

                    @hasanyrole('admin|superadmin')
                        <div>
                            <button id="dropdownMenuIconHorizontalButton" data-dropdown-toggle="dropdownDotsHorizontal" class="inline-flex items-center p-2.5 text-sm font-medium text-center text-gray-700 bg-white border border-gray-200 rounded-lg hover:bg-gray-100 focus:ring-4 focus:outline-none dark:text-white focus:ring-gray-50 dark:bg-gray-900 dark:border-gray-600 dark:hover:bg-gray-700 dark:focus:ring-gray-600 transition-colors" type="button">
                                <svg class="w-5 h-5" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 16 3">
                                    <path d="M2 0a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3Zm6.041 0a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3ZM14 0a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3Z"/>
                                </svg>
                            </button>
                            <div id="dropdownDotsHorizontal" class="z-10 hidden bg-white divide-y divide-gray-100 rounded-lg shadow-lg w-48 dark:bg-gray-700 dark:divide-gray-600 border border-gray-200 dark:border-gray-600">
                                <ul class="py-2 text-sm text-gray-700 dark:text-gray-200" aria-labelledby="dropdownMenuIconHorizontalButton">
                                    <li>
                                        <a href="#" data-modal-target="change-assign-modal" data-modal-toggle="change-assign-modal" class="block px-4 py-2 hover:bg-gray-100 dark:hover:bg-gray-600 dark:hover:text-white transition-colors">
                                            {{ __("Assign an Employee") }}
                                        </a>
                                    </li>
                                    <li>
                                        <a href="#" data-modal-target="change-customer-modal" data-modal-toggle="change-customer-modal" class="block px-4 py-2 hover:bg-gray-100 dark:hover:bg-gray-600 dark:hover:text-white transition-colors">
                                            {{ __("Edit Customer Details") }}
                                        </a>
                                    </li>
                                    <li>
                                        <a href="#" data-modal-target="change-billing-modal" data-modal-toggle="change-billing-modal" class="block px-4 py-2 hover:bg-gray-100 dark:hover:bg-gray-600 dark:hover:text-white transition-colors">
                                            {{ __("Edit Billing Information") }}
                                        </a>
                                    </li>
                                    @if($user->id != '1')
                                    <li>
                                        <a href="#" data-modal-target="change-password-modal" data-modal-toggle="change-password-modal" class="block px-4 py-2 hover:bg-gray-100 dark:hover:bg-gray-600 dark:hover:text-white transition-colors">
                                            {{ __("Reset Password") }}
                                        </a>
                                    </li>
                                    @endif
                                    <li>
                                        <a href="#" data-modal-target="change-roles-modal" data-modal-toggle="change-roles-modal" class="block px-4 py-2 hover:bg-gray-100 dark:hover:bg-gray-600 dark:hover:text-white transition-colors">
                                            {{ __("Assign Roles") }}
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    @endhasanyrole
                </div>

                <!-- Client Information Grid -->
                <div class="grid md:grid-cols-2 gap-4 pt-4 border-t border-gray-200 dark:border-gray-700">
                    <div>
                        <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Company</dt>
                        <dd class="mt-1 text-sm text-gray-900 dark:text-white">{{ $user->company ?: 'Not Set' }}</dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Email</dt>
                        <dd class="mt-1 text-sm text-gray-900 dark:text-white">{{ $user->email }}</dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Account Manager</dt>
                        <dd class="mt-1 text-sm text-gray-900 dark:text-white">
                            @if($user->account_manager)
                                @foreach($account_managers as $account_manager)
                                    @if($user->account_manager == $account_manager->id && $user->id != $account_manager->id)
                                        {{ $account_manager->name }}
                                    @endif
                                @endforeach
                            @else
                                <span class="text-gray-400 dark:text-gray-500">{{ __('Not Assigned') }}</span>
                            @endif
                        </dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Account Type</dt>
                        <dd class="mt-1">
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-blue-100 text-blue-800 dark:bg-blue-900 dark:text-blue-200">
                            @php
                                $customer = \App\Models\User::find($user->id);
                                if($customer)
                                {
                                    $customer_role = $customer->roles->pluck('name')[0];
                                } else {
                                    $customer_role = '';
                                }
            
                                if($customer_role)
                                {
                                    if($customer_role == 'superadmin') {
                                        $role = "Senior Management";
                                    } elseif($customer_role == 'admin') {
                                        $role = "Management";
                                    } elseif($customer_role == 'employee') {
                                        $role = "Employee";
                                    } elseif($customer_role == 'customer') {
                                        $role = "Customer";
                                    } elseif($customer_role == 'developer') {
                                        $role = "Developer";
                                    } else {
                                        $role = "Guest";
                                    }
                                } else {
                                    $role = "Guest";
                                }
                                if(!Auth::guest() && !empty($customer->profile_photo_path))
                                {
                                    $avatar = asset('storage/' . $customer->profile_photo_path);
                                } else {
                                    $avatar = "https://gravatar.com/avatar/". hash('sha256', strtolower(trim($customer->email ?? $ticket->public_email))).".png?default=monsterid";
                                }
                            @endphp
                            {{ ucfirst($role) }}
                            </span>
                        </dd>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Statistics Section -->
    <div class="grid gap-5 md:grid-cols-3 mb-6">
        <div class="bg-white dark:bg-gray-900 border border-gray-200 dark:border-gray-700 rounded-xl shadow-sm overflow-hidden hover:shadow-md transition-shadow">
            <x-mary-stat
                title="Open Tickets"
                value="{{ $total_open }}"
                icon="o-chat-bubble-left-ellipsis"
                color="text-blue-600 dark:text-blue-400"
                class="!bg-transparent p-6 dark:!text-white" />
        </div>
        <div class="bg-white dark:bg-gray-900 border border-gray-200 dark:border-gray-700 rounded-xl shadow-sm overflow-hidden hover:shadow-md transition-shadow">
            <x-mary-stat
                title="Closed Tickets"
                value="{{ $total_closed }}"
                icon="o-chat-bubble-left-right"
                color="text-green-600 dark:text-green-400"
                class="!bg-transparent p-6 dark:!text-white" />
        </div>
        <div class="bg-white dark:bg-gray-900 border border-gray-200 dark:border-gray-700 rounded-xl shadow-sm overflow-hidden hover:shadow-md transition-shadow">
            <x-mary-stat
                title="Total Tickets"
                value="{{ $total_open + $total_closed }}"
                icon="o-ticket"
                color="text-purple-600 dark:text-purple-400"
                class="!bg-transparent p-6 dark:!text-white" />
        </div>
    </div>

    <!-- Tickets Section -->
    <livewire:clients.ticket_widget :client_id="$user->id" />
    <!-- Modals -->
    <div id="change-assign-modal" tabindex="-1" aria-hidden="true" class="hidden overflow-y-auto overflow-x-hidden fixed top-0 right-0 left-0 z-50 justify-center items-center w-full md:inset-0 h-[calc(100%-1rem)] max-h-full">
        <div class="relative p-4 w-full max-w-md max-h-full">
            <div class="relative bg-white rounded-xl shadow-lg dark:bg-gray-900 border border-gray-200 dark:border-gray-700">
                <div class="flex items-center justify-between p-5 border-b border-gray-200 dark:border-gray-700">
                    <h3 class="text-lg font-semibold text-gray-900 dark:text-white">
                        Assign an Account Manager
                    </h3>
                    <button type="button" class="text-gray-400 bg-transparent hover:bg-gray-100 hover:text-gray-900 rounded-lg text-sm w-8 h-8 inline-flex justify-center items-center dark:hover:bg-gray-700 dark:hover:text-white transition-colors" data-modal-hide="change-assign-modal">
                        <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 14 14">
                            <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6"/>
                        </svg>
                        <span class="sr-only">Close modal</span>
                    </button>
                </div>
                <div class="p-5">
                    <livewire:partials.customers.assign :user_id="$user->id"/>
                </div>
            </div>
        </div>
    </div>

    <div id="change-customer-modal" tabindex="-1" aria-hidden="true" class="hidden overflow-y-auto overflow-x-hidden fixed top-0 right-0 left-0 z-50 justify-center items-center w-full md:inset-0 h-[calc(100%-1rem)] max-h-full">
        <div class="relative p-4 w-full max-w-md max-h-full">
            <div class="relative bg-white rounded-xl shadow-lg dark:bg-gray-900 border border-gray-200 dark:border-gray-700">
                <div class="flex items-center justify-between p-5 border-b border-gray-200 dark:border-gray-700">
                    <h3 class="text-lg font-semibold text-gray-900 dark:text-white">
                        Edit Customer Details
                    </h3>
                    <button type="button" class="text-gray-400 bg-transparent hover:bg-gray-100 hover:text-gray-900 rounded-lg text-sm w-8 h-8 inline-flex justify-center items-center dark:hover:bg-gray-700 dark:hover:text-white transition-colors" data-modal-hide="change-customer-modal">
                        <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 14 14">
                            <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6"/>
                        </svg>
                        <span class="sr-only">Close modal</span>
                    </button>
                </div>
                <div class="p-5">
                    <livewire:partials.customers.details :user="$user" :user_id="$user->id"/>
                </div>
            </div>
        </div>
    </div>

    <div id="change-billing-modal" tabindex="-1" aria-hidden="true" class="hidden overflow-y-auto overflow-x-hidden fixed top-0 right-0 left-0 z-50 justify-center items-center w-full md:inset-0 h-[calc(100%-1rem)] max-h-full">
        <div class="relative p-4 w-full max-w-md max-h-full">
            <div class="relative bg-white rounded-xl shadow-lg dark:bg-gray-900 border border-gray-200 dark:border-gray-700">
                <div class="flex items-center justify-between p-5 border-b border-gray-200 dark:border-gray-700">
                    <h3 class="text-lg font-semibold text-gray-900 dark:text-white">
                        Edit Billing Information
                    </h3>
                    <button type="button" class="text-gray-400 bg-transparent hover:bg-gray-100 hover:text-gray-900 rounded-lg text-sm w-8 h-8 inline-flex justify-center items-center dark:hover:bg-gray-700 dark:hover:text-white transition-colors" data-modal-hide="change-billing-modal">
                        <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 14 14">
                            <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6"/>
                        </svg>
                        <span class="sr-only">Close modal</span>
                    </button>
                </div>
                <div class="p-5">
                    <livewire:partials.customers.billing :user="$user" :user_id="$user->id"/>
                </div>
            </div>
        </div>
    </div>

    <div id="change-password-modal" tabindex="-1" aria-hidden="true" class="hidden overflow-y-auto overflow-x-hidden fixed top-0 right-0 left-0 z-50 justify-center items-center w-full md:inset-0 h-[calc(100%-1rem)] max-h-full">
        <div class="relative p-4 w-full max-w-md max-h-full">
            <div class="relative bg-white rounded-xl shadow-lg dark:bg-gray-900 border border-gray-200 dark:border-gray-700">
                <div class="flex items-center justify-between p-5 border-b border-gray-200 dark:border-gray-700">
                    <h3 class="text-lg font-semibold text-gray-900 dark:text-white">
                        Reset Customer Password
                    </h3>
                    <button type="button" class="text-gray-400 bg-transparent hover:bg-gray-100 hover:text-gray-900 rounded-lg text-sm w-8 h-8 inline-flex justify-center items-center dark:hover:bg-gray-700 dark:hover:text-white transition-colors" data-modal-hide="change-password-modal">
                        <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 14 14">
                            <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6"/>
                        </svg>
                        <span class="sr-only">Close modal</span>
                    </button>
                </div>
                <div class="p-5">
                    <livewire:partials.customers.passwords :user="$user" :user_id="$user->id"/>
                </div>
            </div>
        </div>
    </div>

    <div id="change-roles-modal" tabindex="-1" aria-hidden="true" class="hidden overflow-y-auto overflow-x-hidden fixed top-0 right-0 left-0 z-50 justify-center items-center w-full md:inset-0 h-[calc(100%-1rem)] max-h-full">
        <div class="relative p-4 w-full max-w-md max-h-full">
            <div class="relative bg-white rounded-xl shadow-lg dark:bg-gray-900 border border-gray-200 dark:border-gray-700">
                <div class="flex items-center justify-between p-5 border-b border-gray-200 dark:border-gray-700">
                    <h3 class="text-lg font-semibold text-gray-900 dark:text-white">
                        Assign Roles
                    </h3>
                    <button type="button" class="text-gray-400 bg-transparent hover:bg-gray-100 hover:text-gray-900 rounded-lg text-sm w-8 h-8 inline-flex justify-center items-center dark:hover:bg-gray-700 dark:hover:text-white transition-colors" data-modal-hide="change-roles-modal">
                        <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 14 14">
                            <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6"/>
                        </svg>
                        <span class="sr-only">Close modal</span>
                    </button>
                </div>
                <div class="p-5">
                    <livewire:partials.customers.assign-roles :user="$user" :user_id="$user->id" :user_roles="$user_roles"/>
                </div>
            </div>
        </div>
    </div>
</x-layouts.app>
