<x-layouts.app :title="__('System Health Dashboard')">
    <div class="container mx-auto px-3 sm:px-4 py-4 sm:py-8">
        <div class="space-y-4 sm:space-y-6">
            {{-- Header --}}
            <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4">
                <div>
                    <h1 class="text-2xl sm:text-3xl font-bold text-gray-900 dark:text-gray-100">System Health Dashboard</h1>
                    <p class="mt-2 text-sm text-gray-600 dark:text-gray-400">
                        Monitor your Ticaga installation status and identify issues
                    </p>
                </div>
                <div class="flex flex-col sm:flex-row gap-3 w-full sm:w-auto">
                    <a href="{{ route('system.health') }}"
                       class="inline-flex items-center justify-center px-4 py-2 bg-indigo-600 hover:bg-indigo-700 text-white rounded-md text-sm font-medium transition">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15" />
                        </svg>
                        Refresh Status
                    </a>
                    <a href="{{ route('system.verify') }}"
                       target="_blank"
                       class="inline-flex items-center justify-center px-4 py-2 bg-gray-600 hover:bg-gray-700 text-white rounded-md text-sm font-medium transition">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 20l4-16m4 4l4 4-4 4M6 16l-4-4 4-4" />
                        </svg>
                        View JSON
                    </a>
                </div>
            </div>

            {{-- Overall Status Card --}}
            <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-4 sm:p-6">
                <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4">
                    <div>
                        <h2 class="text-lg font-semibold text-gray-900 dark:text-gray-100">Overall System Status</h2>
                        <p class="mt-1 text-sm text-gray-600 dark:text-gray-400">
                            @if ($summary['status'] === 'ok')
                                All systems operational
                            @elseif ($summary['status'] === 'warning')
                                Some warnings detected
                            @else
                                Critical issues require attention
                            @endif
                        </p>
                    </div>
                    <div class="self-start sm:self-auto">
                        @if ($summary['status'] === 'ok')
                            <span class="inline-flex items-center px-4 py-2 rounded-full text-sm font-medium bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200">
                                <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                                </svg>
                                Healthy
                            </span>
                        @elseif ($summary['status'] === 'warning')
                            <span class="inline-flex items-center px-4 py-2 rounded-full text-sm font-medium bg-amber-100 text-amber-800 dark:bg-amber-900 dark:text-amber-200">
                                <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/>
                                </svg>
                                Warnings
                            </span>
                        @else
                            <span class="inline-flex items-center px-4 py-2 rounded-full text-sm font-medium bg-red-100 text-red-800 dark:bg-red-900 dark:text-red-200">
                                <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd"/>
                                </svg>
                                Issues Detected
                            </span>
                        @endif
                    </div>
                </div>

                @if ($summary['installed'])
                    <div class="mt-4 pt-4 border-t border-gray-200 dark:border-gray-700">
                        <p class="text-sm text-gray-600 dark:text-gray-400">
                            <span class="font-medium">Ticaga Version:</span> {{ $summary['version'] ?? 'Unknown' }}
                        </p>
                    </div>
                @endif
            </div>

            {{-- Upgrade Alert --}}
            @if (isset($summary['upgrade']['upgrade_available']) && $summary['upgrade']['upgrade_available'])
                <div class="bg-blue-50 dark:bg-blue-900/20 border-l-4 border-blue-400 p-4 sm:p-6 rounded-lg">
                    <div class="flex items-start">
                        <div class="flex-shrink-0">
                            <svg class="h-6 w-6 text-blue-400" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"/>
                            </svg>
                        </div>
                        <div class="ml-3 flex-1">
                            <h3 class="text-lg font-medium text-blue-800 dark:text-blue-200">
                                Upgrade Available
                            </h3>
                            <div class="mt-2 text-sm text-blue-700 dark:text-blue-300">
                                <p class="mb-3">
                                    A new version of Ticaga is available. Your installation can be upgraded.
                                </p>
                                <div class="bg-white dark:bg-gray-800 rounded-md p-4 mb-3">
                                    <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                                        <div>
                                            <p class="text-xs font-medium text-gray-500 dark:text-gray-400 uppercase">Current Version</p>
                                            <p class="mt-1 text-lg font-semibold text-gray-900 dark:text-gray-100">
                                                {{ $summary['upgrade']['installed_version'] }}
                                            </p>
                                        </div>
                                        <div>
                                            <p class="text-xs font-medium text-gray-500 dark:text-gray-400 uppercase">New Version</p>
                                            <p class="mt-1 text-lg font-semibold text-green-600 dark:text-green-400">
                                                {{ $summary['upgrade']['config_version'] }}
                                            </p>
                                        </div>
                                    </div>
                                </div>
                                <div class="bg-amber-50 dark:bg-amber-900/20 border border-amber-200 dark:border-amber-800 rounded-md p-4">
                                    <p class="font-medium text-amber-800 dark:text-amber-200 mb-2">Upgrade Steps:</p>
                                    <ol class="list-decimal list-inside space-y-2 text-amber-700 dark:text-amber-300 text-sm">
                                        <li>Backup your database before proceeding</li>
                                        <li class="break-words">Run: <code class="px-2 py-1 bg-gray-100 dark:bg-gray-700 rounded text-xs break-all">php artisan migrate --force</code></li>
                                        <li class="break-words">Clear cache: <code class="px-2 py-1 bg-gray-100 dark:bg-gray-700 rounded text-xs break-all">php artisan cache:clear</code></li>
                                        <li class="break-words">Verify upgrade: <code class="px-2 py-1 bg-gray-100 dark:bg-gray-700 rounded text-xs break-all">php artisan ticaga:health --detailed</code></li>
                                    </ol>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            @endif

            {{-- Issues & Warnings --}}
            @if (count($summary['issues']) > 0 || count($summary['warnings']) > 0)
                <div class="space-y-4">
                    @if (count($summary['issues']) > 0)
                        <div class="bg-red-50 dark:bg-red-900/20 border-l-4 border-red-400 p-4">
                            <div class="flex">
                                <div class="flex-shrink-0">
                                    <svg class="h-5 w-5 text-red-400" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd"/>
                                    </svg>
                                </div>
                                <div class="ml-3">
                                    <h3 class="text-sm font-medium text-red-800 dark:text-red-200">Critical Issues</h3>
                                    <div class="mt-2 text-sm text-red-700 dark:text-red-300">
                                        <ul class="list-disc pl-5 space-y-1">
                                            @foreach ($summary['issues'] as $issue)
                                                <li>{{ $issue }}</li>
                                            @endforeach
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif

                    @if (count($summary['warnings']) > 0)
                        <div class="bg-amber-50 dark:bg-amber-900/20 border-l-4 border-amber-400 p-4">
                            <div class="flex">
                                <div class="flex-shrink-0">
                                    <svg class="h-5 w-5 text-amber-400" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/>
                                    </svg>
                                </div>
                                <div class="ml-3">
                                    <h3 class="text-sm font-medium text-amber-800 dark:text-amber-200">Warnings</h3>
                                    <div class="mt-2 text-sm text-amber-700 dark:text-amber-300">
                                        <ul class="list-disc pl-5 space-y-1">
                                            @foreach ($summary['warnings'] as $warning)
                                                <li>{{ $warning }}</li>
                                            @endforeach
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif
                </div>
            @endif

            {{-- Detailed Checks --}}
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4 sm:gap-6">
                {{-- File System Check --}}
                <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-4 sm:p-6">
                    <div class="flex items-center justify-between mb-4">
                        <h3 class="text-lg font-semibold text-gray-900 dark:text-gray-100">Core Files</h3>
                        @php
                            $fileStatus = $summary['checks']['files']['status'];
                        @endphp
                        <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium
                            {{ $fileStatus === 'ok' ? 'bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200' : 'bg-amber-100 text-amber-800 dark:bg-amber-900 dark:text-amber-200' }}">
                            {{ $fileStatus === 'ok' ? 'Complete' : 'Missing Files' }}
                        </span>
                    </div>
                    <div class="space-y-2">
                        <div class="flex justify-between text-sm">
                            <span class="text-gray-600 dark:text-gray-400">Total Files:</span>
                            <span class="font-medium text-gray-900 dark:text-gray-100">{{ $summary['checks']['files']['total'] }}</span>
                        </div>
                        <div class="flex justify-between text-sm">
                            <span class="text-gray-600 dark:text-gray-400">Present:</span>
                            <span class="font-medium text-green-600 dark:text-green-400">{{ $summary['checks']['files']['present'] }}</span>
                        </div>
                        @if ($summary['checks']['files']['missing'] > 0)
                            <div class="flex justify-between text-sm">
                                <span class="text-gray-600 dark:text-gray-400">Missing:</span>
                                <span class="font-medium text-amber-600 dark:text-amber-400">{{ $summary['checks']['files']['missing'] }}</span>
                            </div>
                            <details class="mt-3">
                                <summary class="cursor-pointer text-sm text-indigo-600 dark:text-indigo-400 hover:text-indigo-800 dark:hover:text-indigo-300">
                                    View missing files
                                </summary>
                                <ul class="mt-2 text-xs text-gray-600 dark:text-gray-400 space-y-1 pl-4">
                                    @foreach ($summary['checks']['files']['missing_files'] as $file)
                                        <li class="font-mono">{{ $file }}</li>
                                    @endforeach
                                </ul>
                            </details>
                        @endif
                    </div>
                </div>

                {{-- Database Check --}}
                <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-4 sm:p-6">
                    <div class="flex items-center justify-between mb-4">
                        <h3 class="text-lg font-semibold text-gray-900 dark:text-gray-100">Database</h3>
                        @php
                            $dbStatus = $summary['checks']['database']['status'];
                        @endphp
                        <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium
                            {{ $dbStatus === 'ok' ? 'bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200' : ($dbStatus === 'warning' ? 'bg-amber-100 text-amber-800 dark:bg-amber-900 dark:text-amber-200' : 'bg-red-100 text-red-800 dark:bg-red-900 dark:text-red-200') }}">
                            {{ $dbStatus === 'ok' ? 'Connected' : ($dbStatus === 'warning' ? 'Warning' : 'Disconnected') }}
                        </span>
                    </div>
                    <div class="space-y-2">
                        <div class="flex justify-between text-sm">
                            <span class="text-gray-600 dark:text-gray-400">Connection:</span>
                            <span class="font-medium {{ $summary['checks']['database']['connected'] ? 'text-green-600 dark:text-green-400' : 'text-red-600 dark:text-red-400' }}">
                                {{ $summary['checks']['database']['connected'] ? 'Active' : 'Failed' }}
                            </span>
                        </div>
                        @if ($summary['checks']['database']['connected'])
                            <div class="flex justify-between text-sm">
                                <span class="text-gray-600 dark:text-gray-400">Users Table:</span>
                                <span class="font-medium {{ $summary['checks']['database']['has_users'] ? 'text-green-600 dark:text-green-400' : 'text-amber-600 dark:text-amber-400' }}">
                                    {{ $summary['checks']['database']['has_users'] ? 'Present' : 'Empty' }}
                                </span>
                            </div>
                            <div class="flex justify-between text-sm">
                                <span class="text-gray-600 dark:text-gray-400">Pending Migrations:</span>
                                <span class="font-medium {{ $summary['checks']['database']['pending_migrations'] === 0 ? 'text-green-600 dark:text-green-400' : 'text-amber-600 dark:text-amber-400' }}">
                                    {{ $summary['checks']['database']['pending_migrations'] }}
                                </span>
                            </div>
                        @else
                            <p class="text-sm text-red-600 dark:text-red-400 mt-2">{{ $summary['checks']['database']['error'] }}</p>
                        @endif
                    </div>
                </div>

                {{-- Services Check --}}
                <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-4 sm:p-6">
                    <div class="flex items-center justify-between mb-4">
                        <h3 class="text-lg font-semibold text-gray-900 dark:text-gray-100">Services</h3>
                        @php
                            $serviceStatus = $summary['checks']['services']['status'];
                        @endphp
                        <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium
                            {{ $serviceStatus === 'ok' ? 'bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200' : 'bg-amber-100 text-amber-800 dark:bg-amber-900 dark:text-amber-200' }}">
                            {{ $serviceStatus === 'ok' ? 'Running' : 'Issues' }}
                        </span>
                    </div>
                    <div class="space-y-2">
                        @foreach ($summary['checks']['services']['services'] as $service => $running)
                            <div class="flex justify-between text-sm">
                                <span class="text-gray-600 dark:text-gray-400 capitalize">{{ str_replace('_', ' ', $service) }}:</span>
                                <span class="font-medium {{ $running ? 'text-green-600 dark:text-green-400' : 'text-red-600 dark:text-red-400' }}">
                                    {{ $running ? 'Running' : 'Stopped' }}
                                </span>
                            </div>
                        @endforeach
                    </div>
                </div>

                {{-- Permissions Check --}}
                <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-4 sm:p-6">
                    <div class="flex items-center justify-between mb-4">
                        <h3 class="text-lg font-semibold text-gray-900 dark:text-gray-100">Permissions</h3>
                        @php
                            $permStatus = $summary['checks']['permissions']['status'];
                        @endphp
                        <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium
                            {{ $permStatus === 'ok' ? 'bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200' : 'bg-red-100 text-red-800 dark:bg-red-900 dark:text-red-200' }}">
                            {{ $permStatus === 'ok' ? 'Writable' : 'Issues' }}
                        </span>
                    </div>
                    <div class="space-y-2">
                        @foreach ($summary['checks']['permissions']['directories'] as $dir => $data)
                            <div class="flex flex-col sm:flex-row sm:justify-between gap-1 text-sm">
                                <span class="text-gray-600 dark:text-gray-400 text-xs break-all">{{ $dir }}:</span>
                                <span class="font-medium {{ $data['writable'] ? 'text-green-600 dark:text-green-400' : 'text-red-600 dark:text-red-400' }} whitespace-nowrap">
                                    {{ $data['writable'] ? 'OK' : 'Not Writable' }}
                                </span>
                            </div>
                        @endforeach
                    </div>
                </div>

                {{-- Dependencies Check --}}
                <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-4 sm:p-6">
                    <div class="flex items-center justify-between mb-4">
                        <h3 class="text-lg font-semibold text-gray-900 dark:text-gray-100">Dependencies</h3>
                        @php
                            $depStatus = $summary['checks']['dependencies']['status'];
                        @endphp
                        <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium
                            {{ $depStatus === 'ok' ? 'bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200' : 'bg-amber-100 text-amber-800 dark:bg-amber-900 dark:text-amber-200' }}">
                            {{ $depStatus === 'ok' ? 'Installed' : 'Missing' }}
                        </span>
                    </div>
                    <div class="space-y-2">
                        <div class="flex justify-between text-sm">
                            <span class="text-gray-600 dark:text-gray-400">Composer:</span>
                            <span class="font-medium {{ $summary['checks']['dependencies']['composer'] ? 'text-green-600 dark:text-green-400' : 'text-red-600 dark:text-red-400' }}">
                                {{ $summary['checks']['dependencies']['composer'] ? 'Installed' : 'Missing' }}
                            </span>
                        </div>
                        <div class="flex justify-between text-sm">
                            <span class="text-gray-600 dark:text-gray-400">NPM:</span>
                            <span class="font-medium {{ $summary['checks']['dependencies']['npm'] ? 'text-green-600 dark:text-green-400' : 'text-red-600 dark:text-red-400' }}">
                                {{ $summary['checks']['dependencies']['npm'] ? 'Installed' : 'Missing' }}
                            </span>
                        </div>
                    </div>
                </div>

                {{-- Extensions Check --}}
                <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-4 sm:p-6">
                    <div class="flex items-center justify-between mb-4">
                        <h3 class="text-lg font-semibold text-gray-900 dark:text-gray-100">Extensions</h3>
                        @php
                            $extStatus = $summary['checks']['extensions']['status'];
                        @endphp
                        <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium
                            {{ $extStatus === 'ok' ? 'bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200' : ($extStatus === 'pending' ? 'bg-gray-100 text-gray-800 dark:bg-gray-900 dark:text-gray-200' : 'bg-red-100 text-red-800 dark:bg-red-900 dark:text-red-200') }}">
                            {{ ucfirst($extStatus) }}
                        </span>
                    </div>
                    <div class="space-y-2">
                        @if ($extStatus === 'ok')
                            <div class="flex justify-between text-sm">
                                <span class="text-gray-600 dark:text-gray-400">Installed Extensions:</span>
                                <span class="font-medium text-gray-900 dark:text-gray-100">{{ $summary['checks']['extensions']['installed'] }}</span>
                            </div>
                        @elseif ($extStatus === 'pending')
                            <p class="text-sm text-gray-600 dark:text-gray-400">{{ $summary['checks']['extensions']['message'] }}</p>
                        @else
                            <p class="text-sm text-red-600 dark:text-red-400">{{ $summary['checks']['extensions']['error'] }}</p>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-layouts.app>
