<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class PermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create roles
        $superadminRole = Role::create(['name' => 'superadmin']);
        $adminRole      = Role::create(['name' => 'admin']);
        $employeeRole   = Role::create(['name' => 'employee']);
        $clientRole     = Role::create(['name' => 'customer']);
        $bannedRole     = Role::create(['name' => 'banned']);

        // Help Permissions
        $createDepartments     = Permission::create(['name' => 'create departments']);
        $editDepartments       = Permission::create(['name' => 'edit departments']);
        $deleteDepartment      = Permission::create(['name' => 'delete department']);

        $viewTickets           = Permission::create(['name' => 'view tickets']);

        // Self Help Permissions
        $viewSelfHelp          = Permission::create(['name' => 'view self-help']);

        $createAnnouncement    = Permission::create(['name' => 'create announcement']);
        $viewAnnouncements     = Permission::create(['name' => 'view announcements']);
        $editAnnouncements     = Permission::create(['name' => 'edit announcements']);
        $deleteAnnouncement    = Permission::create(['name' => 'delete announcement']);

        // Announcement Categories
        $createAnnouncement_cat = Permission::create(['name' => 'create announcement category']);
        $viewAnnouncements_cat  = Permission::create(['name' => 'view announcement category']);
        $editAnnouncements_cat  = Permission::create(['name' => 'edit announcement category']);
        $deleteAnnouncement_cat = Permission::create(['name' => 'delete announcement category']);

        // Customer permissions
        $createCustomers       = Permission::create(['name' => 'create customers']);
        $viewCustomers         = Permission::create(['name' => 'view customers']);
        $editCustomers         = Permission::create(['name' => 'edit customers']);
        $deleteCustomer        = Permission::create(['name' => 'delete customer']);

        // Assigned to me Permissions
        $assignedToMe          = Permission::create(['name' => 'view assigned to me']);
        $assignedCustomers     = Permission::create(['name' => 'view assigned customers']);
        $assignedTickets       = Permission::create(['name' => 'view assigned tickets']);

        // Licensing Permissions
        $licensing             = Permission::create(['name' => 'view licensing']);

        $api                   = Permission::create(['name' => 'view api']);

        // Assign permissions to roles
        $superadminRole->givePermissionTo([$api, $licensing, $assignedTickets, $assignedCustomers, $assignedToMe, $createCustomers, $viewCustomers, $editCustomers, $deleteCustomer, $viewSelfHelp, $createAnnouncement, $viewAnnouncements, $editAnnouncements, $deleteAnnouncement, $createAnnouncement_cat, $viewAnnouncements_cat, $editAnnouncements_cat, $deleteAnnouncement_cat, $viewTickets, $createDepartments, $editDepartments, $deleteDepartment]);

        $adminRole->givePermissionTo([$licensing, $assignedTickets, $assignedCustomers, $assignedToMe, $createCustomers, $viewCustomers, $editCustomers, $deleteCustomer, $viewSelfHelp, $createAnnouncement, $viewAnnouncements, $editAnnouncements, $deleteAnnouncement, $createAnnouncement_cat, $viewAnnouncements_cat, $editAnnouncements_cat, $deleteAnnouncement_cat, $viewTickets, $createDepartments, $editDepartments, $deleteDepartment]);

        $employeeRole->givePermissionTo([$assignedTickets, $assignedCustomers, $assignedToMe, $viewCustomers, $editCustomers, $viewSelfHelp, $viewAnnouncements, $editAnnouncements, $viewTickets ]);

        $clientRole->givePermissionTo([$viewSelfHelp, $viewAnnouncements, $viewTickets]);

    }
}