<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\{DB, Schema};

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('extensions')) {
            return;
        }

        Schema::table('extensions', function (Blueprint $table) {
            if (!Schema::hasColumn('extensions', 'installed')) {
                $table->boolean('installed')->default(false)->after('version');
            }
        });

        if (Schema::hasColumn('extensions', 'installed')) {
            // Preserve existing behaviour: extensions that are currently enabled
            // should remain marked as installed.
            DB::table('extensions')->update(['installed' => DB::raw('enabled')]);
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (!Schema::hasTable('extensions')) {
            return;
        }

        Schema::table('extensions', function (Blueprint $table) {
            if (Schema::hasColumn('extensions', 'installed')) {
                $table->dropColumn('installed');
            }
        });
    }
};
