<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('announcements', function (Blueprint $table) {
            $table->id();
            $table->integer('parent_category');
            $table->string('title');
            $table->string('slug');
            $table->string('image');
            $table->longText('content');
            $table->string('tags');
            $table->string('views')->default('0');
            $table->integer('likes')->default('0');
            $table->integer('draft')->default('0');
            $table->integer('private')->default('0');
            $table->integer('soft_deleted')->default('0');
            $table->integer('author_id')->default('0');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('announcements');
    }
};