<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
        {
            Schema::create('responses', function (Blueprint $table) {
                $table->id();
                $table->integer('user_id');
                $table->integer('ticket_number');
                $table->longText('content');
                $table->string('organize')->default('ticket')->nullable();
                $table->integer('is_note')->default('0');
                $table->integer('employee_response')->default('0');
                $table->string('ip_address')->nullable();
                $table->timestamps();
            });
        }

        /**
         * Reverse the migrations.
         */
        public function down(): void
        {
            Schema::dropIfExists('responses');
        }
};
