<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\{Str,Carbon};

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\User>
 */
class TicketsFactory extends Factory
{

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
		'user_id' => fake()->numberBetween(2,6),
                'subject' => fake()->sentence(),
                'message' => fake()->paragraphs(2, true),
                'status' => fake()->randomElement(['open', 'awaiting reply', 'in progress', 'closed']),
                'priority' => fake()->randomElement(['low', 'medium', 'high', 'emergency']),
                'cc' => '',
                'assigned' => '0',
                'department_id' => fake()->numberBetween(1,2),
                'public_hash' => Str::random(20),
                'public_name' => null,
                'public_email' => null,
                'rating' => '0',
                'ip_address' => fake()->ipv4(),
                'organize' => 'ticket',
                'date_closed' => null,
                'updated_by_client_at' => Carbon::now(),
                'created_at' => Carbon::now(),
                'updated_at' => null,
                'first_employee_reply' => null,
        ];
    }
}
