<?php

namespace App\Models;

use App\Enums\LogType;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Logs extends Model
{
    use HasFactory;

    public const UPDATED_AT = null;

    protected $primaryKey = 'log_id';

    protected $fillable = [
        'log_type',
        'user_id',
        'customer_id',
        'message',
        'ip_address',
        'visible',
    ];

    protected $casts = [
        'log_type' => LogType::class,
        'visible' => 'boolean',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function customer(): BelongsTo
    {
        return $this->belongsTo(User::class, 'customer_id');
    }

    public function scopeVisible(Builder $query): Builder
    {
        return $query->where('visible', true);
    }

    public function scopeOfType(Builder $query, LogType $type): Builder
    {
        return $query->where('log_type', $type);
    }
}
