<?php

namespace App\Livewire;

use App\Models\Tickets;
use Illuminate\Support\Facades\Auth;
use Livewire\Component;
use Livewire\Attributes\On;

class SidebarNavigation extends Component
{
    public $openTicketsCount = 0;
    public $assignedTicketsCount = 0;

    public function mount()
    {
        $this->updateCounts();
    }

    #[On('ticket-updated')]
    public function updateCounts()
    {
        if (Auth::check()) {
            // Calculate open tickets count based on user role
            if (auth()->user()->hasanyrole('admin', 'employee', 'superadmin')) {
                $this->openTicketsCount = Tickets::where('status', '!=', 'closed')->count();
            } else {
                $this->openTicketsCount = Tickets::where('user_id', auth()->id())
                    ->where('status', '!=', 'closed')
                    ->count();
            }

            // Calculate assigned tickets count (non-closed tickets assigned to user)
            $this->assignedTicketsCount = Tickets::where('assigned', auth()->id())
                ->where('status', '!=', 'closed')
                ->count();
        }
    }

    public function getBadgeColorProperty()
    {
        if ($this->openTicketsCount > 9) {
            return 'red';
        }
        return 'zinc';
    }

    public function render()
    {
        return view('livewire.sidebar-navigation');
    }
}
