<?php

namespace App\Livewire\Partials\Tickets;

use App\Models\{User,Tickets};
#use App\Http\Controllers\{TicketsController};

use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\{DB, Auth};
use Illuminate\Http\RedirectResponse;

use Livewire\Component;

class Statistics extends Component
{
    public function render()
    {
        if(auth()->user()->hasanyrole('superadmin', 'admin','employee'))
        {
            $count_open = Tickets::where('status', '!=', 'closed')->get();
            $high_priority = Tickets::where('status', '!=', 'closed')->whereIn('priority', ['high', 'emergency'])->get();
            $all_count = Tickets::all();

            return view('livewire.partials.tickets.statistics',[
                'open_count' => count($count_open),
                'high_priority' => count($high_priority),
                'all_count' => count($all_count),
            ]);
        } elseif(!auth()->user()->hasanyrole('superadmin','admin','employee')) {
            $count_open = Tickets::where('status', '!=', 'closed')->where('user_id', '=', Auth::user()->id)->get();
            $all_closed = Tickets::where('status', '=', 'closed')->where('user_id', '=', Auth::user()->id)->get();
            $all_tickets = Tickets::where('user_id', '=', Auth::user()->id)->get();
            
            return view('livewire.partials.tickets.statistics',[
                'open_count' => count($count_open),
                'all_closed' => count($all_closed),
                'all_count' => count($all_tickets),
            ]);
        }
    }
}
