<?php

namespace App\Livewire\Partials\Dashboard;

use App\Models\{User,Tickets};
#use App\Http\Controllers\{TicketsController};

use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\{DB, Auth};
use Illuminate\Http\RedirectResponse;

use Livewire\Component;

class Statistics extends Component
{
    public function render()
    {
        if(!Auth::guest()){
            if(auth()->user()->hasanyrole('admin','employee','superadmin')) {
                $count_open = Tickets::where('status', '!=', 'closed')->get();
                $high_priority = Tickets::where('priority', '=', 'high')->orWhere('priority', '=', 'emergency')->where('status', '!=', 'closed')->get();
                $assigned_tickets = Tickets::where('status', '!=', 'closed')->where('assigned', '!=', '0')->get();
                
                return view('livewire.partials.dashboard.statistics',[
                    'open_count' => count($count_open),
                    'high_priority' => count($high_priority),
                    'assigned_tickets' => count($assigned_tickets),
                ]);
            } else {
                $count_open         = Tickets::where('status', '!=', 'open')->where('status', '!=', 'closed')->where('user_id', '=', Auth::user()->id)->get();
                $count_awaiting     = Tickets::where('status', '=', 'open')->where('user_id', '=', Auth::user()->id)->get();
                $count_closed       = Tickets::where('status', '=', 'closed')->where('user_id', '=', Auth::user()->id)->get();
                
                return view('livewire.partials.dashboard.statistics',[
                    'open_count' => count($count_open),
                    'awaiting_count' => count($count_awaiting),
                    'closed_count' => count($count_closed),
                ]);
            }
        }
    }
}
