<?php

namespace App\Livewire\Partials\Announcements\Categories;

use App\Http\Controllers\{CategoriesController};
use Livewire\Attributes\{Rule, Validate};
use Illuminate\Support\{Str,Carbon};

use Livewire\Component;

class Create extends Component
{
    #[Rule('string', message: "Please enter a name for the Category.")]
    public $category_name;

    public $uri = '';

    #[Rule('numeric', message: "Please select Displayed or Disabled.")]
    public $display;

    public function create()
    {
        $this->validate();
        
        if($this->uri)
        {
            $uri = Str::of($this->uri)->slug('-');
        } else {
            $uri = Str::of($this->category_name)->slug('-');
        }

        CategoriesController::store([
            'category_name' => $this->category_name,
            'uri' => $uri,
            'display' => $this->display,
            'type' => 'announcements',
        ]);

        $this->reset();
        $this->redirect('/announcements');
    }

    public function render()
    {
        return view('livewire.partials.announcements.categories.create');
    }
}
