<?php

namespace App\Http\Controllers;

use App\Models\Departments;
use Illuminate\Http\Request;

use Illuminate\Support\{Str,Carbon};

class DepartmentsController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        return view('departments.index');
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        if (!auth()->user()->can('create departments')) {
            return redirect()->route('departments');
        }
        return view('departments.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public static function store($department)
    {
        return Departments::insert([
            'department_name' => $department['department_name'],
            'department_description' => $department['department_description'],
            'slug' => Str::lower($department['slug']),
            'department_email' => $department['department_email'],
            'allows_high_priority' => $department['allows_high_priority'],
            'cc_enabled' => $department['cc_enabled'],
            'is_disabled' => $department['is_disabled'],
            'is_public' => $department['is_public'],
            'created_at' => Carbon::now(),
            'updated_at' => null,
        ]);
    }

    /**
     * Display the specified resource.
     */
    public function show(Departments $departments)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(int $department_id)
    {
        if (!auth()->user()->can('edit departments')) {
            return redirect()->route('departments');
        }
        
        
        return view('departments.edit',[
            'department_id' => $department_id
        ]);
    }

    /**
     * Update the specified resource in storage.
     */
    public static function update($department)
    {
        return Departments::where('id', $department['department_id'])
            ->update([
                'department_name' => $department['department_name'],
                'department_description' => $department['department_description'],
                'slug' => Str::lower($department['slug']),
                'department_email' => $department['department_email'],
                'allows_high_priority' => $department['allows_high_priority'],
                'cc_enabled' => $department['cc_enabled'],
                'is_disabled' => $department['is_disabled'],
                'is_public' => $department['is_public'],
                'updated_at' => Carbon::now(),
            ]);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Departments $departments)
    {
        //
    }
}
