<?php

use App\Extensions\Concerns\ChecksExtensionInstallation;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    use ChecksExtensionInstallation;

    public function up(): void
    {
        if (!Schema::hasTable("importer_jobs")) {
            return;
        }

        DB::statement("
            ALTER TABLE `importer_jobs`
            MODIFY `source` ENUM(
                'csv','database','supportpal','blesta','whmcs','clientexec',
                'freshdesk','zendesk'
            ) NOT NULL
        ");
    }

    public function down(): void
    {
        if (
            $this->shouldSkipRollback("importer") ||
            !Schema::hasTable("importer_jobs")
        ) {
            return;
        }

        DB::statement("
            ALTER TABLE `importer_jobs`
            MODIFY `source` ENUM('csv','database','supportpal','blesta','whmcs','clientexec') NOT NULL
        ");
    }
};
