<?php

namespace App\Extensions\Hooks;

/**
 * Predefined hook names for Ticaga extensions
 */
class Hooks
{
    // Ticket lifecycle hooks
    public const TICKET_CREATED = 'ticket.created';
    public const TICKET_UPDATED = 'ticket.updated';
    public const TICKET_DELETED = 'ticket.deleted';
    public const TICKET_CLOSED = 'ticket.closed';
    public const TICKET_REOPENED = 'ticket.reopened';
    public const TICKET_ASSIGNED = 'ticket.assigned';

    // Response hooks
    public const RESPONSE_CREATED = 'response.created';
    public const RESPONSE_UPDATED = 'response.updated';

    // Department hooks
    public const DEPARTMENT_CREATED = 'department.created';
    public const DEPARTMENT_UPDATED = 'department.updated';
    public const DEPARTMENT_DELETED = 'department.deleted';

    // User/Customer hooks
    public const USER_CREATED = 'user.created';
    public const USER_UPDATED = 'user.updated';
    public const USER_DELETED = 'user.deleted';
    public const USER_LOGIN = 'user.login';
    public const USER_LOGOUT = 'user.logout';

    // Email hooks
    public const EMAIL_SENDING = 'email.sending';
    public const EMAIL_SENT = 'email.sent';
    public const EMAIL_FAILED = 'email.failed';

    // System hooks
    public const SYSTEM_BOOT = 'system.boot';
    public const SYSTEM_SHUTDOWN = 'system.shutdown';

    // UI hooks (for adding content to specific areas)
    public const UI_TICKET_SIDEBAR = 'ui.ticket.sidebar';
    public const UI_DASHBOARD_WIDGETS = 'ui.dashboard.widgets';
    public const UI_NAVIGATION_MENU = 'ui.navigation.menu';
    public const UI_USER_PROFILE = 'ui.user.profile';

    // Filter hooks (for modifying data)
    public const FILTER_TICKET_DATA = 'filter.ticket.data';
    public const FILTER_RESPONSE_DATA = 'filter.response.data';
    public const FILTER_USER_DATA = 'filter.user.data';

    /**
     * Get all available hook names
     */
    public static function all(): array
    {
        $reflection = new \ReflectionClass(self::class);
        return array_values($reflection->getConstants());
    }

    /**
     * Get hooks by category
     */
    public static function byCategory(string $category): array
    {
        $reflection = new \ReflectionClass(self::class);
        $constants = $reflection->getConstants();

        return array_filter($constants, function ($name) use ($category) {
            return str_starts_with(strtolower($name), strtolower($category));
        }, ARRAY_FILTER_USE_KEY);
    }
}
