<?php

namespace App\Extensions\Contracts;

interface ExtensionInterface
{
    /**
     * Get the extension's unique identifier (slug)
     */
    public function getId(): string;

    /**
     * Get the extension's display name
     */
    public function getName(): string;

    /**
     * Get the extension's description
     */
    public function getDescription(): string;

    /**
     * Get the extension's version
     */
    public function getVersion(): string;

    /**
     * Get the extension's author
     */
    public function getAuthor(): string;

    /**
     * Get the minimum required Ticaga version
     */
    public function getRequiredTicagaVersion(): ?string;

    /**
     * Called when the extension is installed
     */
    public function install(): void;

    /**
     * Called when the extension is enabled
     */
    public function enable(): void;

    /**
     * Called when the extension is disabled
     */
    public function disable(): void;

    /**
     * Called when the extension is uninstalled
     */
    public function uninstall(): void;

    /**
     * Register extension routes
     */
    public function registerRoutes(): void;

    /**
     * Register extension views
     */
    public function registerViews(): void;

    /**
     * Register extension migrations
     */
    public function registerMigrations(): void;

    /**
     * Get extension configuration
     */
    public function getConfig(): array;

    /**
     * Check if extension is compatible with current Ticaga version
     */
    public function isCompatible(): bool;
}
